/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.cassandra.testutils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.UUID;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.contrib.utils.service.CassandraServiceDataCleaner;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.cassandra.service.EmbeddedCassandraService;
import org.apache.thrift.transport.TTransportException;

public class EmbeddedServerHelper {
    private static final String TMP = "tmp";
    private EmbeddedCassandraService cassandra;
    private final String yamlFile;

    public EmbeddedServerHelper() {
        this("/cassandra.yaml");
    }

    public EmbeddedServerHelper(String yamlFile) {
        this.yamlFile = yamlFile;
    }

    public void setup() throws TTransportException, IOException, InterruptedException, ConfigurationException {
        EmbeddedServerHelper.rmdir(TMP);
        EmbeddedServerHelper.copy("/log4j.properties", TMP);
        EmbeddedServerHelper.copy(this.yamlFile, TMP);
        System.setProperty("cassandra.config", "file:tmp" + this.yamlFile);
        CassandraServiceDataCleaner cleaner = new CassandraServiceDataCleaner();
        cleaner.prepare();
        this.loadYamlTables();
        this.cassandra = new EmbeddedCassandraService();
        this.cassandra.init();
        Thread t = new Thread((Runnable)this.cassandra);
        t.setDaemon(true);
        t.start();
    }

    private void loadYamlTables() throws ConfigurationException {
        for (KSMetaData table : DatabaseDescriptor.readTablesFromYaml()) {
            for (CFMetaData cfm : table.cfMetaData().values()) {
                CFMetaData.map((CFMetaData)cfm);
            }
            DatabaseDescriptor.setTableDefinition((KSMetaData)table, (UUID)DatabaseDescriptor.getDefsVersion());
        }
    }

    public void teardown() {
        CassandraServiceDataCleaner cleaner = new CassandraServiceDataCleaner();
        try {
            cleaner.cleanupDataDirectories();
            EmbeddedServerHelper.rmdir(TMP);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void rmdir(String dir) throws IOException {
        File dirFile = new File(dir);
        if (dirFile.exists()) {
            FileUtils.deleteRecursive((File)new File(dir));
        }
    }

    private static void copy(String resource, String directory) throws IOException {
        int len;
        EmbeddedServerHelper.mkdir(directory);
        InputStream is = EmbeddedServerHelper.class.getResourceAsStream(resource);
        String fileName = resource.substring(resource.lastIndexOf("/") + 1);
        File file = new File(directory + System.getProperty("file.separator") + fileName);
        FileOutputStream out = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        while ((len = is.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        ((OutputStream)out).close();
        is.close();
    }

    private static void mkdir(String dir) throws IOException {
        FileUtils.createDirectory((String)dir);
    }
}

