package org.apache.cassandra.db.migration;

import java.io.IOException;

import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ConfigurationException;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.config.KSMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.Table;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.UUIDGen;

/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * <p/>
 * http://www.apache.org/licenses/LICENSE-2.0
 * <p/>
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** todo: doesn't work with secondary indices yet. See CASSANDRA-1415. */
public class UpdateColumnFamily extends Migration
{
    // does not point to a CFM stored in DatabaseDescriptor.
    private CFMetaData metadata;
    
    protected UpdateColumnFamily() { }
    
    /** assumes validation has already happened. That is, replacing oldCfm with newCfm is neither illegal or totally whackass. */
    public UpdateColumnFamily(org.apache.cassandra.avro.CfDef cf_def) throws ConfigurationException, IOException
    {
        super(UUIDGen.makeType1UUIDFromHost(FBUtilities.getLocalAddress()), DatabaseDescriptor.getDefsVersion());
        
        KSMetaData ksm = DatabaseDescriptor.getTableDefinition(cf_def.keyspace.toString());
        if (ksm == null)
            throw new ConfigurationException("Keyspace does not already exist.");
        
        CFMetaData oldCfm = DatabaseDescriptor.getCFMetaData(CFMetaData.getId(cf_def.keyspace.toString(), cf_def.name.toString()));
        
        // create a copy of the old CF meta data. Apply new settings on top of it.
        this.metadata = CFMetaData.inflate(oldCfm.deflate());
        this.metadata.apply(cf_def);
        
        // create a copy of the old KS meta data. Use it to create a RowMutation that gets applied to schema and migrations.
        KSMetaData newKsMeta = KSMetaData.inflate(ksm.deflate());
        newKsMeta.cfMetaData().get(cf_def.name.toString()).apply(cf_def);
        rm = Migration.makeDefinitionMutation(newKsMeta, null, newVersion);
    }
    
    public void beforeApplyModels()
    {
        if (clientMode)
            return;
        ColumnFamilyStore cfs = Table.open(metadata.tableName).getColumnFamilyStore(metadata.cfName);
        cfs.snapshot(Table.getTimestampedSnapshotName(null));
    }

    void applyModels() throws IOException
    {
        logger.debug("Updating " + DatabaseDescriptor.getCFMetaData(metadata.cfId) + " to " + metadata);
        // apply the meta update.
        try 
        {
            DatabaseDescriptor.getCFMetaData(metadata.cfId).apply(CFMetaData.convertToAvro(metadata));
        } 
        catch (ConfigurationException ex) 
        {
            throw new IOException(ex);
        }
        DatabaseDescriptor.setTableDefinition(null, newVersion);

        if (!clientMode)
        {
            Table table = Table.open(metadata.tableName);
            ColumnFamilyStore oldCfs = table.getColumnFamilyStore(metadata.cfName);
            oldCfs.reload();
        }
    }

    public void subdeflate(org.apache.cassandra.db.migration.avro.Migration mi)
    {
        org.apache.cassandra.db.migration.avro.UpdateColumnFamily update = new org.apache.cassandra.db.migration.avro.UpdateColumnFamily();
        update.metadata = metadata.deflate();
        mi.migration = update;
    }

    public void subinflate(org.apache.cassandra.db.migration.avro.Migration mi)
    {
        org.apache.cassandra.db.migration.avro.UpdateColumnFamily update = (org.apache.cassandra.db.migration.avro.UpdateColumnFamily)mi.migration;
        metadata = CFMetaData.inflate(update.metadata);
    }
}
