/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.net;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import java.io.DataOutputStream;
import java.io.IOError;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.cassandra.concurrent.DebuggableThreadPoolExecutor;
import org.apache.cassandra.concurrent.StageManager;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.io.util.DataOutputBuffer;
import org.apache.cassandra.locator.ILatencyPublisher;
import org.apache.cassandra.locator.ILatencySubscriber;
import org.apache.cassandra.net.AsyncResult;
import org.apache.cassandra.net.IAsyncCallback;
import org.apache.cassandra.net.IAsyncResult;
import org.apache.cassandra.net.IMessageCallback;
import org.apache.cassandra.net.IVerbHandler;
import org.apache.cassandra.net.IncomingTcpConnection;
import org.apache.cassandra.net.Message;
import org.apache.cassandra.net.MessageDeliveryTask;
import org.apache.cassandra.net.MessagingServiceMBean;
import org.apache.cassandra.net.OutboundTcpConnection;
import org.apache.cassandra.net.OutboundTcpConnectionPool;
import org.apache.cassandra.net.io.SerializerType;
import org.apache.cassandra.net.sink.SinkManager;
import org.apache.cassandra.service.GCInspector;
import org.apache.cassandra.service.StorageService;
import org.apache.cassandra.streaming.FileStreamTask;
import org.apache.cassandra.streaming.StreamHeader;
import org.apache.cassandra.utils.ExpiringMap;
import org.apache.cassandra.utils.GuidGenerator;
import org.apache.cassandra.utils.SimpleCondition;
import org.cliffc.high_scale_lib.NonBlockingHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagingService
implements MessagingServiceMBean,
ILatencyPublisher {
    private static int version_ = 1;
    private static SerializerType serializerType_ = SerializerType.BINARY;
    public static final int PROTOCOL_MAGIC = -900387334;
    private static ExpiringMap<String, IMessageCallback> callbacks;
    private static Multimap<String, InetAddress> targets;
    private static Map<StorageService.Verb, IVerbHandler> verbHandlers_;
    private static ExecutorService streamExecutor_;
    private static NonBlockingHashMap<InetAddress, OutboundTcpConnectionPool> connectionManagers_;
    private static Logger logger_;
    private static int LOG_DROPPED_INTERVAL_IN_MS;
    public static final MessagingService instance;
    private SocketThread socketThread;
    private SimpleCondition listenGate;
    private static final Map<StorageService.Verb, AtomicInteger> droppedMessages;
    private final List<ILatencySubscriber> subscribers = new ArrayList<ILatencySubscriber>();

    public Object clone() throws CloneNotSupportedException {
        throw new CloneNotSupportedException();
    }

    protected MessagingService() {
        this.listenGate = new SimpleCondition();
        verbHandlers_ = new EnumMap<StorageService.Verb, IVerbHandler>(StorageService.Verb.class);
        streamExecutor_ = new DebuggableThreadPoolExecutor("Streaming", DatabaseDescriptor.getCompactionThreadPriority());
        Runnable logDropped = new Runnable(){

            @Override
            public void run() {
                MessagingService.logDroppedMessages();
            }
        };
        StorageService.scheduledTasks.scheduleWithFixedDelay(logDropped, LOG_DROPPED_INTERVAL_IN_MS, LOG_DROPPED_INTERVAL_IN_MS, TimeUnit.MILLISECONDS);
        Function<String, Object> timeoutReporter = new Function<String, Object>(){

            public Object apply(String messageId) {
                Collection addresses = targets.removeAll((Object)messageId);
                if (addresses == null) {
                    return null;
                }
                for (InetAddress address : addresses) {
                    for (ILatencySubscriber subscriber : MessagingService.this.subscribers) {
                        subscriber.receiveTiming(address, Double.valueOf(DatabaseDescriptor.getRpcTimeout()));
                    }
                }
                return null;
            }
        };
        targets = ArrayListMultimap.create();
        callbacks = new ExpiringMap((long)(1.1 * (double)DatabaseDescriptor.getRpcTimeout()), timeoutReporter);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, new ObjectName("org.apache.cassandra.net:type=MessagingService"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public byte[] hash(String type, byte[] data) {
        byte[] result;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(type);
            result = messageDigest.digest(data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return result;
    }

    public void convict(InetAddress ep) {
        logger_.debug("Resetting pool for " + ep);
        MessagingService.getConnectionPool(ep).reset();
    }

    public void listen(InetAddress localEp) throws IOException {
        ServerSocketChannel serverChannel = ServerSocketChannel.open();
        ServerSocket ss = serverChannel.socket();
        ss.setReuseAddress(true);
        ss.bind(new InetSocketAddress(localEp, DatabaseDescriptor.getStoragePort()));
        this.socketThread = new SocketThread(ss, "ACCEPT-" + localEp);
        this.socketThread.start();
        this.listenGate.signalAll();
    }

    public void waitUntilListening() {
        try {
            this.listenGate.await();
        }
        catch (InterruptedException ie) {
            logger_.debug("await interrupted");
        }
    }

    public static OutboundTcpConnectionPool getConnectionPool(InetAddress to) {
        OutboundTcpConnectionPool cp = (OutboundTcpConnectionPool)connectionManagers_.get((Object)to);
        if (cp == null) {
            connectionManagers_.putIfAbsent((Object)to, (Object)new OutboundTcpConnectionPool(to));
            cp = (OutboundTcpConnectionPool)connectionManagers_.get((Object)to);
        }
        return cp;
    }

    public static OutboundTcpConnection getConnection(InetAddress to, Message msg) {
        return MessagingService.getConnectionPool(to).getConnection(msg);
    }

    public void registerVerbHandlers(StorageService.Verb verb, IVerbHandler verbHandler) {
        assert (!verbHandlers_.containsKey((Object)verb));
        verbHandlers_.put(verb, verbHandler);
    }

    public IVerbHandler getVerbHandler(StorageService.Verb type) {
        return verbHandlers_.get((Object)type);
    }

    public String sendRR(Message message, Collection<InetAddress> to, IAsyncCallback cb) {
        String messageId = message.getMessageId();
        this.addCallback(cb, messageId);
        for (InetAddress endpoint : to) {
            targets.put((Object)messageId, (Object)endpoint);
            this.sendOneWay(message, endpoint);
        }
        return messageId;
    }

    public void addCallback(IAsyncCallback cb, String messageId) {
        callbacks.put(messageId, cb);
    }

    public String sendRR(Message message, InetAddress to, IAsyncCallback cb) {
        String messageId = message.getMessageId();
        this.addCallback(cb, messageId);
        targets.put((Object)messageId, (Object)to);
        this.sendOneWay(message, to);
        return messageId;
    }

    public String sendRR(Message[] messages, List<InetAddress> to, IAsyncCallback cb) {
        if (messages.length != to.size()) {
            throw new IllegalArgumentException("Number of messages and the number of endpoints need to be same.");
        }
        String groupId = GuidGenerator.guid();
        this.addCallback(cb, groupId);
        for (int i = 0; i < messages.length; ++i) {
            messages[i].setMessageId(groupId);
            targets.put((Object)groupId, (Object)to.get(i));
            this.sendOneWay(messages[i], to.get(i));
        }
        return groupId;
    }

    public void sendOneWay(Message message, InetAddress to) {
        byte[] data;
        Object buffer;
        if (message.getFrom().equals(to)) {
            MessagingService.receive(message);
            return;
        }
        Message processedMessage = SinkManager.processClientMessage(message, to);
        if (processedMessage == null) {
            return;
        }
        OutboundTcpConnection connection = MessagingService.getConnection(to, message);
        try {
            buffer = new DataOutputBuffer();
            Message.serializer().serialize(message, (DataOutputStream)buffer);
            data = ((DataOutputBuffer)buffer).getData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        assert (data.length > 0);
        buffer = MessagingService.packIt(data, false);
        connection.write((ByteBuffer)buffer);
    }

    public IAsyncResult sendRR(Message message, InetAddress to) {
        AsyncResult iar = new AsyncResult();
        callbacks.put(message.getMessageId(), iar);
        targets.put((Object)message.getMessageId(), (Object)to);
        this.sendOneWay(message, to);
        return iar;
    }

    public void stream(StreamHeader header, InetAddress to) {
        streamExecutor_.execute(new FileStreamTask(header, to));
    }

    @Override
    public void register(ILatencySubscriber subcriber) {
        this.subscribers.add(subcriber);
    }

    public static void waitFor() throws InterruptedException {
        while (!streamExecutor_.isTerminated()) {
            streamExecutor_.awaitTermination(5L, TimeUnit.SECONDS);
        }
    }

    public static void shutdown() {
        logger_.info("Shutting down MessageService...");
        try {
            MessagingService.instance.socketThread.close();
        }
        catch (IOException e) {
            throw new IOError(e);
        }
        streamExecutor_.shutdownNow();
        callbacks.shutdown();
        logger_.info("Shutdown complete (no further commands will be processed)");
    }

    public static void receive(Message message) {
        if ((message = SinkManager.processServerMessage(message)) == null) {
            return;
        }
        MessageDeliveryTask runnable = new MessageDeliveryTask(message);
        ThreadPoolExecutor stage = StageManager.getStage(message.getMessageType());
        assert (stage != null) : "No stage for message type " + (Object)((Object)message.getMessageType());
        stage.execute(runnable);
    }

    public static IMessageCallback getRegisteredCallback(String messageId) {
        return callbacks.get(messageId);
    }

    public static IMessageCallback removeRegisteredCallback(String messageId) {
        targets.removeAll((Object)messageId);
        return callbacks.remove(messageId);
    }

    public static long getRegisteredCallbackAge(String messageId) {
        return callbacks.getAge(messageId);
    }

    public static void responseReceivedFrom(String messageId, InetAddress from) {
        targets.remove((Object)messageId, (Object)from);
    }

    public static void validateMagic(int magic) throws IOException {
        if (magic != -900387334) {
            throw new IOException("invalid protocol header");
        }
    }

    public static int getBits(int x, int p, int n) {
        return x >>> p + 1 - n & ~(-1 << n);
    }

    public static ByteBuffer packIt(byte[] bytes, boolean compress) {
        int header = 0;
        header |= serializerType_.ordinal();
        if (compress) {
            header |= 4;
        }
        ByteBuffer buffer = ByteBuffer.allocate(12 + bytes.length);
        buffer.putInt(-900387334);
        buffer.putInt(header |= version_ << 8);
        buffer.putInt(bytes.length);
        buffer.put(bytes);
        buffer.flip();
        return buffer;
    }

    public static ByteBuffer constructStreamHeader(StreamHeader streamHeader, boolean compress) {
        byte[] bytes;
        Object buffer;
        int header = 0;
        header |= serializerType_.ordinal();
        if (compress) {
            header |= 4;
        }
        header |= 8;
        header |= version_ << 8;
        try {
            buffer = new DataOutputBuffer();
            StreamHeader.serializer().serialize(streamHeader, (DataOutputStream)buffer);
            bytes = ((DataOutputBuffer)buffer).getData();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        assert (bytes.length > 0);
        buffer = ByteBuffer.allocate(12 + bytes.length);
        ((ByteBuffer)buffer).putInt(-900387334);
        ((ByteBuffer)buffer).putInt(header);
        ((ByteBuffer)buffer).putInt(bytes.length);
        ((ByteBuffer)buffer).put(bytes);
        ((ByteBuffer)buffer).flip();
        return buffer;
    }

    public static int incrementDroppedMessages(StorageService.Verb verb) {
        return droppedMessages.get((Object)verb).incrementAndGet();
    }

    private static void logDroppedMessages() {
        boolean logTpstats = false;
        for (Map.Entry<StorageService.Verb, AtomicInteger> entry : droppedMessages.entrySet()) {
            AtomicInteger dropped = entry.getValue();
            if (dropped.get() > 0) {
                logTpstats = true;
                logger_.warn("Dropped {} {} messages in the last {}ms", new Object[]{dropped, entry.getKey(), LOG_DROPPED_INTERVAL_IN_MS});
            }
            dropped.set(0);
        }
        if (logTpstats) {
            GCInspector.instance.logStats();
        }
    }

    @Override
    public Map<String, Integer> getCommandPendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>();
        for (Map.Entry entry : connectionManagers_.entrySet()) {
            pendingTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).cmdCon.getPendingMessages());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getCommandCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>();
        for (Map.Entry entry : connectionManagers_.entrySet()) {
            completedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).cmdCon.getCompletedMesssages());
        }
        return completedTasks;
    }

    @Override
    public Map<String, Integer> getResponsePendingTasks() {
        HashMap<String, Integer> pendingTasks = new HashMap<String, Integer>();
        for (Map.Entry entry : connectionManagers_.entrySet()) {
            pendingTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).ackCon.getPendingMessages());
        }
        return pendingTasks;
    }

    @Override
    public Map<String, Long> getResponseCompletedTasks() {
        HashMap<String, Long> completedTasks = new HashMap<String, Long>();
        for (Map.Entry entry : connectionManagers_.entrySet()) {
            completedTasks.put(((InetAddress)entry.getKey()).getHostAddress(), ((OutboundTcpConnectionPool)entry.getValue()).ackCon.getCompletedMesssages());
        }
        return completedTasks;
    }

    static {
        connectionManagers_ = new NonBlockingHashMap();
        logger_ = LoggerFactory.getLogger(MessagingService.class);
        LOG_DROPPED_INTERVAL_IN_MS = 5000;
        instance = new MessagingService();
        droppedMessages = new EnumMap<StorageService.Verb, AtomicInteger>(StorageService.Verb.class);
        for (StorageService.Verb verb : StorageService.Verb.values()) {
            droppedMessages.put(verb, new AtomicInteger());
        }
    }

    private static class SocketThread
    extends Thread {
        private final ServerSocket server;

        SocketThread(ServerSocket server, String name) {
            super(name);
            this.server = server;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Socket socket = this.server.accept();
                    new IncomingTcpConnection(socket).start();
                }
            }
            catch (AsynchronousCloseException e) {
                logger_.info("MessagingService shutting down server thread.");
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        void close() throws IOException {
            this.server.close();
        }
    }
}

