/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.keystone.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import org.jclouds.openstack.keystone.v2_0.config.CredentialType;

@CredentialType(value="apiAccessKeyCredentials")
public class ApiAccessKeyCredentials {
    private final String accessKey;
    private final String secretKey;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromApiAccessKeyCredentials(this);
    }

    public static ApiAccessKeyCredentials createWithAccessKeyAndSecretKey(String accessKey, String secretKey) {
        return new ApiAccessKeyCredentials(accessKey, secretKey);
    }

    @ConstructorProperties(value={"accessKey", "secretKey"})
    protected ApiAccessKeyCredentials(String accessKey, String secretKey) {
        this.accessKey = (String)Preconditions.checkNotNull((Object)accessKey, (Object)"accessKey");
        this.secretKey = (String)Preconditions.checkNotNull((Object)secretKey, (Object)"secretKey");
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.accessKey, this.secretKey});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ApiAccessKeyCredentials that = (ApiAccessKeyCredentials)ApiAccessKeyCredentials.class.cast(obj);
        return Objects.equal((Object)this.accessKey, (Object)that.accessKey) && Objects.equal((Object)this.secretKey, (Object)that.secretKey);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("accessKey", (Object)this.accessKey).add("secretKey", (Object)this.secretKey);
    }

    public String toString() {
        return this.string().toString();
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String accessKey;
        protected String secretKey;

        protected abstract T self();

        public T accessKey(String accessKey) {
            this.accessKey = accessKey;
            return this.self();
        }

        public T secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this.self();
        }

        public ApiAccessKeyCredentials build() {
            return new ApiAccessKeyCredentials(this.accessKey, this.secretKey);
        }

        public T fromApiAccessKeyCredentials(ApiAccessKeyCredentials in) {
            return ((Builder)this.accessKey(in.getAccessKey())).secretKey(in.getSecretKey());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

