/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.v2_0.functions;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.openstack.v2_0.predicates.ExtensionPredicates;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.reflect.InvocationSuccess;
import org.jclouds.rest.functions.ImplicitOptionalConverter;
import org.jclouds.util.Optionals2;

public class PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet
implements ImplicitOptionalConverter {
    private final LoadingCache<String, Set<? extends org.jclouds.openstack.v2_0.domain.Extension>> extensions;
    private final Multimap<URI, URI> aliases;

    @Inject
    public PresentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet(LoadingCache<String, Set<? extends org.jclouds.openstack.v2_0.domain.Extension>> extensions, Multimap<URI, URI> aliases) {
        this.extensions = (LoadingCache)Preconditions.checkNotNull(extensions, (Object)"extensions");
        this.aliases = aliases == null ? ImmutableMultimap.of() : ImmutableMultimap.copyOf(aliases);
    }

    public Optional<Object> apply(InvocationSuccess input) {
        Class target = Optionals2.unwrapIfOptional((TypeToken)input.getInvocation().getInvokable().getReturnType());
        Optional ext = Optional.fromNullable((Object)target.getAnnotation(Extension.class));
        if (ext.isPresent()) {
            URI namespace = URI.create(((Extension)ext.get()).namespace());
            List args = input.getInvocation().getArgs();
            if (args.isEmpty()) {
                if (Iterables.any((Iterable)((Iterable)this.extensions.getUnchecked((Object)"")), ExtensionPredicates.namespaceOrAliasEquals(namespace, this.aliases.get((Object)namespace)))) {
                    return input.getResult();
                }
            } else if (args.size() == 1) {
                String arg0 = Preconditions.checkNotNull(args.get(0), (String)"arg[0] in %s", (Object[])new Object[]{input}).toString();
                if (Iterables.any((Iterable)((Iterable)this.extensions.getUnchecked((Object)arg0)), ExtensionPredicates.namespaceOrAliasEquals(namespace, this.aliases.get((Object)namespace)))) {
                    return input.getResult();
                }
            } else {
                throw new RuntimeException(String.format("expecting zero or one args %s", input));
            }
            return Optional.absent();
        }
        return input.getResult();
    }

    public String toString() {
        return "presentWhenExtensionAnnotationNamespaceEqualsAnyNamespaceInExtensionsSet()";
    }
}

