/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.Resource;

public class Image
extends Resource {
    private final Date updated;
    private final Date created;
    @Named(value="tenant_id")
    private final String tenantId;
    @Named(value="user_id")
    private final String userId;
    private final Status status;
    private final int progress;
    private final int minDisk;
    private final int minRam;
    private final Resource server;
    private final Map<String, String> metadata;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromImage(this);
    }

    @ConstructorProperties(value={"id", "name", "links", "updated", "created", "tenant_id", "user_id", "status", "progress", "minDisk", "minRam", "server", "metadata"})
    protected Image(String id, @Nullable String name, Set<Link> links, @Nullable Date updated, @Nullable Date created, String tenantId, @Nullable String userId, @Nullable Status status, int progress, int minDisk, int minRam, @Nullable Resource server, @Nullable Map<String, String> metadata) {
        super(id, name, links);
        this.updated = updated;
        this.created = created;
        this.tenantId = tenantId;
        this.userId = userId;
        this.status = status;
        this.progress = progress;
        this.minDisk = minDisk;
        this.minRam = minRam;
        this.server = server;
        this.metadata = metadata == null ? ImmutableMap.of() : ImmutableMap.copyOf(metadata);
    }

    @Nullable
    public Date getUpdated() {
        return this.updated;
    }

    @Nullable
    public Date getCreated() {
        return this.created;
    }

    @Nullable
    public String getTenantId() {
        return this.tenantId;
    }

    @Nullable
    public String getUserId() {
        return this.userId;
    }

    @Nullable
    public Status getStatus() {
        return this.status;
    }

    public int getProgress() {
        return this.progress;
    }

    public int getMinDisk() {
        return this.minDisk;
    }

    public int getMinRam() {
        return this.minRam;
    }

    @Nullable
    public Resource getServer() {
        return this.server;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.updated, this.created, this.tenantId, this.userId, this.status, this.progress, this.minDisk, this.minRam, this.server, this.metadata});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        Image that = (Image)((Object)Image.class.cast(obj));
        return super.equals((Object)that) && Objects.equal((Object)this.updated, (Object)that.updated) && Objects.equal((Object)this.created, (Object)that.created) && Objects.equal((Object)this.tenantId, (Object)that.tenantId) && Objects.equal((Object)this.userId, (Object)that.userId) && Objects.equal((Object)((Object)this.status), (Object)((Object)that.status)) && Objects.equal((Object)this.progress, (Object)that.progress) && Objects.equal((Object)this.minDisk, (Object)that.minDisk) && Objects.equal((Object)this.minRam, (Object)that.minRam) && Objects.equal((Object)this.server, (Object)that.server) && Objects.equal(this.metadata, that.metadata);
    }

    protected Objects.ToStringHelper string() {
        return super.string().add("updated", (Object)this.updated).add("created", (Object)this.created).add("tenantId", (Object)this.tenantId).add("userId", (Object)this.userId).add("status", (Object)this.status).add("progress", this.progress).add("minDisk", this.minDisk).add("minRam", this.minRam).add("server", (Object)this.server).add("metadata", this.metadata);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends Resource.Builder<T> {
        protected Date updated;
        protected Date created;
        protected String tenantId;
        protected String userId;
        protected Status status;
        protected int progress;
        protected int minDisk;
        protected int minRam;
        protected Resource server;
        protected Map<String, String> metadata = ImmutableMap.of();

        public T updated(Date updated) {
            this.updated = updated;
            return (T)((Object)((Builder)this.self()));
        }

        public T created(Date created) {
            this.created = created;
            return (T)((Object)((Builder)this.self()));
        }

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return (T)((Object)((Builder)this.self()));
        }

        public T userId(String userId) {
            this.userId = userId;
            return (T)((Object)((Builder)this.self()));
        }

        public T status(Status status) {
            this.status = status;
            return (T)((Object)((Builder)this.self()));
        }

        public T progress(int progress) {
            this.progress = progress;
            return (T)((Object)((Builder)this.self()));
        }

        public T minDisk(int minDisk) {
            this.minDisk = minDisk;
            return (T)((Object)((Builder)this.self()));
        }

        public T minRam(int minRam) {
            this.minRam = minRam;
            return (T)((Object)((Builder)this.self()));
        }

        public T server(Resource server) {
            this.server = server;
            return (T)((Object)((Builder)this.self()));
        }

        public T metadata(Map<String, String> metadata) {
            this.metadata = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(metadata, (Object)"metadata")));
            return (T)((Object)((Builder)this.self()));
        }

        public Image build() {
            return new Image(this.id, this.name, this.links, this.updated, this.created, this.tenantId, this.userId, this.status, this.progress, this.minDisk, this.minRam, this.server, this.metadata);
        }

        public T fromImage(Image in) {
            return ((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)((Object)((Builder)super.fromResource((Resource)in)).updated(in.getUpdated()))).created(in.getCreated()))).tenantId(in.getTenantId()))).userId(in.getUserId()))).status(in.getStatus()))).progress(in.getProgress()))).minDisk(in.getMinDisk()))).minRam(in.getMinRam()))).server(in.getServer()))).metadata(in.getMetadata());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        protected ConcreteBuilder self() {
            return this;
        }
    }

    public static enum Status {
        UNRECOGNIZED,
        UNKNOWN,
        ACTIVE,
        SAVING,
        ERROR,
        DELETED;


        public String value() {
            return this.name();
        }

        public static Status fromValue(String v) {
            try {
                return Status.valueOf(v);
            }
            catch (IllegalArgumentException e) {
                return UNRECOGNIZED;
            }
        }
    }
}

