/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.inject.Named;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.nova.v2_0.domain.SimpleServerUsage;

public class SimpleTenantUsage {
    @Named(value="tenant_id")
    private final String tenantId;
    @Named(value="total_local_gb_usage")
    private final double totalLocalGbUsage;
    @Named(value="total_vcpus_usage")
    private final double totalVcpusUsage;
    @Named(value="total_memory_mb_usage")
    private final double totalMemoryMbUsage;
    @Named(value="total_hours")
    private final double totalHours;
    private final Date start;
    private final Date stop;
    @Named(value="server_usages")
    private final Set<SimpleServerUsage> serverUsages;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSimpleTenantUsage(this);
    }

    @ConstructorProperties(value={"tenant_id", "total_local_gb_usage", "total_vcpus_usage", "total_memory_mb_usage", "total_hours", "start", "stop", "server_usages"})
    protected SimpleTenantUsage(String tenantId, double totalLocalGbUsage, double totalVcpusUsage, double totalMemoryMbUsage, double totalHours, @Nullable Date start, @Nullable Date stop, @Nullable Set<SimpleServerUsage> serverUsages) {
        this.tenantId = (String)Preconditions.checkNotNull((Object)tenantId, (Object)"tenantId");
        this.totalLocalGbUsage = totalLocalGbUsage;
        this.totalVcpusUsage = totalVcpusUsage;
        this.totalMemoryMbUsage = totalMemoryMbUsage;
        this.totalHours = totalHours;
        this.start = start;
        this.stop = stop;
        this.serverUsages = serverUsages == null ? ImmutableSet.of() : ImmutableSet.copyOf(serverUsages);
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public double getTotalLocalGbUsage() {
        return this.totalLocalGbUsage;
    }

    public double getTotalVcpusUsage() {
        return this.totalVcpusUsage;
    }

    public double getTotalMemoryMbUsage() {
        return this.totalMemoryMbUsage;
    }

    public double getTotalHours() {
        return this.totalHours;
    }

    @Nullable
    public Date getStart() {
        return this.start;
    }

    @Nullable
    public Date getStop() {
        return this.stop;
    }

    public Set<SimpleServerUsage> getServerUsages() {
        return this.serverUsages;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.tenantId, this.totalLocalGbUsage, this.totalVcpusUsage, this.totalMemoryMbUsage, this.totalHours, this.start, this.stop, this.serverUsages});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleTenantUsage that = (SimpleTenantUsage)SimpleTenantUsage.class.cast(obj);
        return Objects.equal((Object)this.tenantId, (Object)that.tenantId) && Objects.equal((Object)this.totalLocalGbUsage, (Object)that.totalLocalGbUsage) && Objects.equal((Object)this.totalVcpusUsage, (Object)that.totalVcpusUsage) && Objects.equal((Object)this.totalMemoryMbUsage, (Object)that.totalMemoryMbUsage) && Objects.equal((Object)this.totalHours, (Object)that.totalHours) && Objects.equal((Object)this.start, (Object)that.start) && Objects.equal((Object)this.stop, (Object)that.stop) && Objects.equal(this.serverUsages, that.serverUsages);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("tenantId", (Object)this.tenantId).add("totalLocalGbUsage", this.totalLocalGbUsage).add("totalVcpusUsage", this.totalVcpusUsage).add("totalMemoryMbUsage", this.totalMemoryMbUsage).add("totalHours", this.totalHours).add("start", (Object)this.start).add("stop", (Object)this.stop).add("serverUsages", this.serverUsages);
    }

    public String toString() {
        return this.string().toString();
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String tenantId;
        protected double totalLocalGbUsage;
        protected double totalVcpusUsage;
        protected double totalMemoryMbUsage;
        protected double totalHours;
        protected Date start;
        protected Date stop;
        protected Set<SimpleServerUsage> serverUsages = ImmutableSet.of();

        protected abstract T self();

        public T tenantId(String tenantId) {
            this.tenantId = tenantId;
            return this.self();
        }

        public T totalLocalGbUsage(double totalLocalGbUsage) {
            this.totalLocalGbUsage = totalLocalGbUsage;
            return this.self();
        }

        public T totalVcpusUsage(double totalVcpusUsage) {
            this.totalVcpusUsage = totalVcpusUsage;
            return this.self();
        }

        public T totalMemoryMbUsage(double totalMemoryMbUsage) {
            this.totalMemoryMbUsage = totalMemoryMbUsage;
            return this.self();
        }

        public T totalHours(double totalHours) {
            this.totalHours = totalHours;
            return this.self();
        }

        public T start(Date start) {
            this.start = start;
            return this.self();
        }

        public T stop(Date stop) {
            this.stop = stop;
            return this.self();
        }

        public T serverUsages(Set<SimpleServerUsage> serverUsages) {
            this.serverUsages = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(serverUsages, (Object)"serverUsages")));
            return this.self();
        }

        public T serverUsages(SimpleServerUsage ... in) {
            return this.serverUsages((Set<SimpleServerUsage>)ImmutableSet.copyOf((Object[])in));
        }

        public SimpleTenantUsage build() {
            return new SimpleTenantUsage(this.tenantId, this.totalLocalGbUsage, this.totalVcpusUsage, this.totalMemoryMbUsage, this.totalHours, this.start, this.stop, this.serverUsages);
        }

        public T fromSimpleTenantUsage(SimpleTenantUsage in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)this.tenantId(in.getTenantId())).totalLocalGbUsage(in.getTotalLocalGbUsage())).totalVcpusUsage(in.getTotalVcpusUsage())).totalMemoryMbUsage(in.getTotalMemoryMbUsage())).totalHours(in.getTotalHours())).start(in.getStart())).stop(in.getStop())).serverUsages(in.getServerUsages());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

