/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.extensions;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import java.util.Map;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jclouds.Fallbacks;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.nova.v2_0.domain.VolumeType;
import org.jclouds.openstack.nova.v2_0.options.CreateVolumeTypeOptions;
import org.jclouds.openstack.v2_0.services.Extension;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.MapBinder;
import org.jclouds.rest.annotations.Payload;
import org.jclouds.rest.annotations.PayloadParam;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Unwrap;
import org.jclouds.rest.annotations.WrapWith;
import org.jclouds.rest.binders.BindToJsonPayload;

@Extension(of="compute", namespace="http://docs.openstack.org/ext/volume_types/api/v1.1")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Path(value="/os-volume-types")
@Beta
public interface VolumeTypeApi {
    @Named(value="volumeType:list")
    @GET
    @SelectJson(value={"volume_types"})
    @Fallback(value=Fallbacks.EmptyFluentIterableOnNotFoundOr404.class)
    public FluentIterable<VolumeType> list();

    @Named(value="volumeType:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"volume_type"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public VolumeType get(@PathParam(value="id") String var1);

    @Named(value="volumeType:create")
    @POST
    @SelectJson(value={"volume_type"})
    @Produces(value={"application/json"})
    @WrapWith(value="volume_type")
    public VolumeType create(@PayloadParam(value="name") String var1, CreateVolumeTypeOptions ... var2);

    @Named(value="volumeType:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);

    @Named(value="volumeType:getExtraSpecs")
    @GET
    @Path(value="/{id}/extra_specs")
    @SelectJson(value={"extra_specs"})
    @Fallback(value=Fallbacks.EmptyMapOnNotFoundOr404.class)
    public Map<String, String> getExtraSpecs(@PathParam(value="id") String var1);

    @Named(value="volumeType:updateExtraSpecs")
    @POST
    @Path(value="/{id}/extra_specs")
    @Produces(value={"application/json"})
    @MapBinder(value=BindToJsonPayload.class)
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean updateExtraSpecs(@PathParam(value="id") String var1, @PayloadParam(value="extra_specs") Map<String, String> var2);

    @Named(value="volumeType:getExtraSpec")
    @GET
    @Path(value="/{id}/extra_specs/{key}")
    @Unwrap
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public String getExtraSpec(@PathParam(value="id") String var1, @PathParam(value="key") String var2);

    @Named(value="volumeType:updateExtraSpec")
    @PUT
    @Path(value="/{id}/extra_specs/{key}")
    @Produces(value={"application/json"})
    @Payload(value="%7B\"{key}\":\"{value}\"%7D")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean updateExtraSpec(@PathParam(value="id") String var1, @PathParam(value="key") @PayloadParam(value="key") String var2, @PayloadParam(value="value") String var3);

    @Named(value="volumeType:deleteExtraSpec")
    @DELETE
    @Path(value="/{id}/extra_specs/{key}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean deleteExtraSpec(@PathParam(value="id") String var1, @PathParam(value="key") String var2);
}

