/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.nova.v2_0.predicates;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import java.util.concurrent.TimeUnit;
import org.jclouds.openstack.nova.v2_0.domain.Server;
import org.jclouds.openstack.nova.v2_0.features.ServerApi;
import org.jclouds.util.Predicates2;

public class ServerPredicates {
    private static final int TEN_MINUTES = 600;
    private static final int FIVE_SECONDS = 5;

    public static Predicate<String> awaitActive(ServerApi serverApi) {
        return ServerPredicates.awaitStatus(serverApi, Server.Status.ACTIVE, 600L, 5L);
    }

    public static Predicate<String> awaitShutoff(ServerApi serverApi) {
        return ServerPredicates.awaitStatus(serverApi, Server.Status.SHUTOFF, 600L, 5L);
    }

    public static Predicate<String> awaitStatus(ServerApi serverApi, Server.Status status, long maxWaitInSec, long periodInSec) {
        ServerStatusPredicate statusPredicate = new ServerStatusPredicate(serverApi, status);
        return Predicates2.retry((Predicate)statusPredicate, (long)maxWaitInSec, (long)periodInSec, (long)periodInSec, (TimeUnit)TimeUnit.SECONDS);
    }

    public static class ServerStatusPredicate
    implements Predicate<String> {
        private final ServerApi serverApi;
        private final Server.Status status;

        public ServerStatusPredicate(ServerApi serverApi, Server.Status status) {
            this.serverApi = (ServerApi)Preconditions.checkNotNull((Object)serverApi, (Object)"serverApi must be defined");
            this.status = (Server.Status)((Object)Preconditions.checkNotNull((Object)((Object)status), (Object)"status must be defined"));
        }

        public boolean apply(String serverId) {
            Preconditions.checkNotNull((Object)serverId, (Object)"server must be defined");
            Server server = this.serverApi.get(serverId);
            if (server == null) {
                throw new IllegalStateException(String.format("Server %s not found.", serverId));
            }
            return this.status.equals((Object)server.getStatus());
        }
    }
}

