/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.domain;

import com.google.common.base.Objects;

public class AllocationPool {
    protected final String start;
    protected final String end;

    protected AllocationPool(String start, String end) {
        this.start = start;
        this.end = end;
    }

    public String getStart() {
        return this.start;
    }

    public String getEnd() {
        return this.end;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.start, this.end});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AllocationPool that = (AllocationPool)AllocationPool.class.cast(obj);
        return Objects.equal((Object)this.start, (Object)that.start) && Objects.equal((Object)this.end, (Object)that.end);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("start", (Object)this.start).add("end", (Object)this.end);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().fromAllocationPool(this);
    }

    public static class Builder {
        protected String start;
        protected String end;

        public Builder start(String start) {
            this.start = start;
            return this;
        }

        public Builder end(String end) {
            this.end = end;
            return this;
        }

        public AllocationPool build() {
            return new AllocationPool(this.start, this.end);
        }

        public Builder fromAllocationPool(AllocationPool in) {
            return this.start(in.getStart()).end(in.getEnd());
        }
    }
}

