/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2.features;

import com.google.common.annotations.Beta;
import com.google.common.collect.FluentIterable;
import java.util.List;
import javax.inject.Named;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.jclouds.Fallbacks;
import org.jclouds.collect.PagedIterable;
import org.jclouds.javax.annotation.Nullable;
import org.jclouds.openstack.keystone.v2_0.filters.AuthenticateRequest;
import org.jclouds.openstack.neutron.v2.domain.Port;
import org.jclouds.openstack.neutron.v2.domain.Ports;
import org.jclouds.openstack.neutron.v2.fallbacks.EmptyPortsFallback;
import org.jclouds.openstack.neutron.v2.functions.ParsePorts;
import org.jclouds.openstack.neutron.v2.functions.PortsToPagedIterable;
import org.jclouds.openstack.v2_0.options.PaginationOptions;
import org.jclouds.rest.annotations.Fallback;
import org.jclouds.rest.annotations.RequestFilters;
import org.jclouds.rest.annotations.ResponseParser;
import org.jclouds.rest.annotations.SelectJson;
import org.jclouds.rest.annotations.Transform;
import org.jclouds.rest.annotations.WrapWith;

@Path(value="/v2.0/ports")
@RequestFilters(value={AuthenticateRequest.class})
@Consumes(value={"application/json"})
@Beta
public interface PortApi {
    @Named(value="port:list")
    @GET
    @Transform(value=PortsToPagedIterable.class)
    @ResponseParser(value=ParsePorts.class)
    @Fallback(value=Fallbacks.EmptyPagedIterableOnNotFoundOr404.class)
    public PagedIterable<Port> list();

    @Named(value="port:list")
    @GET
    @ResponseParser(value=ParsePorts.class)
    @Fallback(value=EmptyPortsFallback.class)
    public Ports list(PaginationOptions var1);

    @Named(value="port:get")
    @GET
    @Path(value="/{id}")
    @SelectJson(value={"port"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    @Nullable
    public Port get(@PathParam(value="id") String var1);

    @Named(value="port:create")
    @POST
    @SelectJson(value={"port"})
    public Port create(@WrapWith(value="port") Port.CreateOptions var1);

    @Named(value="port:createBulk")
    @POST
    @SelectJson(value={"ports"})
    public FluentIterable<Port> createBulk(@WrapWith(value="ports") List<Port.CreateOptions> var1);

    @Named(value="port:update")
    @PUT
    @Path(value="/{id}")
    @SelectJson(value={"port"})
    @Fallback(value=Fallbacks.NullOnNotFoundOr404.class)
    public Port update(@PathParam(value="id") String var1, @WrapWith(value="port") Port.UpdateOptions var2);

    @Named(value="port:delete")
    @DELETE
    @Path(value="/{id}")
    @Fallback(value=Fallbacks.FalseOnNotFoundOr404.class)
    public boolean delete(@PathParam(value="id") String var1);
}

