/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.openstack.neutron.v2_0.domain.IP;

public class BulkPort {
    private final String name;
    private final String networkId;
    private final Boolean adminStateUp;
    private final String deviceId;
    private final String deviceOwner;
    private final Set<IP> fixedIps;
    private final String macAddress;

    @ConstructorProperties(value={"name", "network_id", "admin_state_up", "device_id", "device_owner", "fixed_ips", "mac_address"})
    protected BulkPort(String name, String networkId, Boolean adminStateUp, String deviceId, String deviceOwner, Set<IP> fixedIps, String macAddress) {
        this.name = name;
        this.networkId = networkId;
        this.adminStateUp = adminStateUp;
        this.deviceId = deviceId;
        this.deviceOwner = deviceOwner;
        this.fixedIps = fixedIps != null ? ImmutableSet.copyOf(fixedIps) : ImmutableSet.of();
        this.macAddress = macAddress;
    }

    public String getName() {
        return this.name;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceOwner() {
        return this.deviceOwner;
    }

    public Set<IP> getFixedIps() {
        return this.fixedIps;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.networkId, this.adminStateUp, this.deviceId, this.deviceOwner, this.fixedIps, this.macAddress});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BulkPort that = (BulkPort)BulkPort.class.cast(obj);
        return Objects.equal((Object)this.name, (Object)that.name) && Objects.equal((Object)this.networkId, (Object)that.networkId) && Objects.equal((Object)this.adminStateUp, (Object)that.adminStateUp) && Objects.equal((Object)this.deviceId, (Object)that.deviceId) && Objects.equal((Object)this.deviceOwner, (Object)that.deviceOwner) && Objects.equal(this.fixedIps, that.fixedIps) && Objects.equal((Object)this.macAddress, (Object)that.macAddress);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("networkId", (Object)this.networkId).add("adminStateUp", (Object)this.adminStateUp).add("deviceId", (Object)this.deviceId).add("deviceOwner", (Object)this.deviceOwner).add("fixedIps", this.fixedIps).add("macAddress", (Object)this.macAddress);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromBulkPort(this);
    }

    public static abstract class Builder {
        protected String name;
        protected String networkId;
        protected String deviceId;
        protected String deviceOwner;
        protected String macAddress;
        protected Set<IP> fixedIps;
        protected Boolean adminStateUp;

        protected abstract Builder self();

        public Builder name(String name) {
            this.name = name;
            return this.self();
        }

        public Builder networkId(String networkId) {
            this.networkId = networkId;
            return this.self();
        }

        public Builder deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this.self();
        }

        public Builder deviceOwner(String deviceOwner) {
            this.deviceOwner = deviceOwner;
            return this.self();
        }

        public Builder macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this.self();
        }

        public Builder fixedIps(Collection<IP> fixedIps) {
            this.fixedIps = ImmutableSet.copyOf(fixedIps);
            return this.self();
        }

        public Builder adminStateUp(Boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return this.self();
        }

        public BulkPort build() {
            return new BulkPort(this.name, this.networkId, this.adminStateUp, this.deviceId, this.deviceOwner, this.fixedIps, this.macAddress);
        }

        public Builder fromBulkPort(BulkPort in) {
            return this.name(in.getName()).networkId(in.getNetworkId()).adminStateUp(in.getAdminStateUp()).deviceId(in.getDeviceId()).deviceOwner(in.getDeviceOwner()).fixedIps(in.getFixedIps()).macAddress(in.getMacAddress());
        }
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

