/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.openstack.neutron.v2_0.domain.NetworkType;
import org.jclouds.openstack.neutron.v2_0.domain.ReferenceWithName;
import org.jclouds.openstack.neutron.v2_0.domain.State;

public class Network
extends ReferenceWithName {
    private final State state;
    private final Set<String> subnets;
    private final Boolean adminStateUp;
    private final Boolean shared;
    private final Boolean external;
    private final NetworkType networkType;
    private final String physicalNetworkName;
    private final Integer segmentationId;

    @ConstructorProperties(value={"id", "tenant_id", "name", "status", "subnets", "admin_state_up", "shared", "router:external", "provider:network_type", "provider:physical_network", "provider:segmentation_id"})
    protected Network(String id, String tenantId, String name, State state, Set<String> subnets, Boolean adminStateUp, Boolean shared, Boolean external, String networkType, String physicalNetworkName, Integer segmentationId) {
        super(id, tenantId, name);
        this.state = state;
        this.subnets = subnets != null ? ImmutableSet.copyOf(subnets) : ImmutableSet.of();
        this.adminStateUp = adminStateUp;
        this.shared = shared;
        this.external = external;
        this.networkType = networkType != null ? NetworkType.fromValue(networkType) : null;
        this.physicalNetworkName = physicalNetworkName;
        this.segmentationId = segmentationId;
    }

    public State getState() {
        return this.state;
    }

    public Set<String> getSubnets() {
        return this.subnets;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public Boolean getShared() {
        return this.shared;
    }

    public Boolean getExternal() {
        return this.external;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String getPhysicalNetworkName() {
        return this.physicalNetworkName;
    }

    public Integer getSegmentationId() {
        return this.segmentationId;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.state, this.subnets, this.adminStateUp, this.shared, this.external, this.networkType, this.physicalNetworkName, this.segmentationId});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Network that = (Network)Network.class.cast(obj);
        return super.equals(obj) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal(this.subnets, that.subnets) && Objects.equal((Object)this.adminStateUp, (Object)that.adminStateUp) && Objects.equal((Object)this.shared, (Object)that.shared) && Objects.equal((Object)this.external, (Object)that.external) && Objects.equal((Object)((Object)this.networkType), (Object)((Object)that.networkType)) && Objects.equal((Object)this.physicalNetworkName, (Object)that.physicalNetworkName) && Objects.equal((Object)this.segmentationId, (Object)that.segmentationId);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("state", (Object)this.state).add("subnets", this.subnets).add("adminStateUp", (Object)this.adminStateUp).add("shared", (Object)this.shared).add("external", (Object)this.external).add("networkType", (Object)this.networkType).add("physicalNetworkName", (Object)this.physicalNetworkName).add("segmentationId", (Object)this.segmentationId);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    @Override
    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromNetwork(this);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends ReferenceWithName.Builder<T> {
        protected State state;
        protected Set<String> subnets;
        protected Boolean adminStateUp;
        protected Boolean shared;
        protected Boolean external;
        protected NetworkType networkType;
        protected String physicalNetworkName;
        protected Integer segmentationId;

        public T state(State state) {
            this.state = state;
            return (T)((Builder)this.self());
        }

        public T subnets(Set<String> subnets) {
            this.subnets = subnets;
            return (T)((Builder)this.self());
        }

        public T adminStateUp(Boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return (T)((Builder)this.self());
        }

        public T shared(Boolean shared) {
            this.shared = shared;
            return (T)((Builder)this.self());
        }

        public T external(Boolean external) {
            this.external = external;
            return (T)((Builder)this.self());
        }

        public T networkType(NetworkType networkType) {
            this.networkType = networkType;
            return (T)((Builder)this.self());
        }

        public T physicalNetworkName(String physicalNetworkName) {
            this.physicalNetworkName = physicalNetworkName;
            return (T)((Builder)this.self());
        }

        public T segmentationId(Integer segmentationId) {
            this.segmentationId = segmentationId;
            return (T)((Builder)this.self());
        }

        @Override
        public Network build() {
            return new Network(this.id, this.tenantId, this.name, this.state, this.subnets, this.adminStateUp, this.shared, this.external, this.networkType == null ? null : this.networkType.getValue(), this.physicalNetworkName, this.segmentationId);
        }

        public T fromNetwork(Network in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)super.fromReference(in)).state(in.getState())).subnets(in.getSubnets())).adminStateUp(in.getAdminStateUp())).shared(in.getShared())).external(in.getExternal())).networkType(in.getNetworkType())).physicalNetworkName(in.getPhysicalNetworkName())).segmentationId(in.getSegmentationId());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

