/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.beans.ConstructorProperties;
import java.util.Set;
import org.jclouds.openstack.neutron.v2_0.domain.IP;
import org.jclouds.openstack.neutron.v2_0.domain.ReferenceWithName;
import org.jclouds.openstack.neutron.v2_0.domain.State;

public class Port
extends ReferenceWithName {
    private final State state;
    private final Boolean adminStateUp;
    private final String networkId;
    private final String deviceId;
    private final String deviceOwner;
    private final String macAddress;
    private final Set<IP> fixedIps;

    @ConstructorProperties(value={"id", "tenant_id", "name", "status", "network_id", "admin_state_up", "device_id", "device_owner", "fixed_ips", "mac_address"})
    protected Port(String id, String tenantId, String name, State state, String networkId, Boolean adminStateUp, String deviceId, String deviceOwner, Set<IP> fixedIps, String macAddress) {
        super(id, tenantId, name);
        this.adminStateUp = adminStateUp;
        this.state = state;
        this.networkId = (String)Preconditions.checkNotNull((Object)networkId, (Object)"networkId");
        this.deviceId = deviceId;
        this.deviceOwner = deviceOwner;
        this.fixedIps = fixedIps;
        this.macAddress = macAddress;
    }

    public State getState() {
        return this.state;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceOwner() {
        return this.deviceOwner;
    }

    public Set<IP> getFixedIps() {
        return this.fixedIps;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.state, this.adminStateUp, this.networkId, this.deviceId, this.deviceOwner, this.fixedIps, this.macAddress});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Port that = (Port)Port.class.cast(obj);
        return super.equals(obj) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)this.adminStateUp, (Object)that.adminStateUp) && Objects.equal((Object)this.networkId, (Object)that.networkId) && Objects.equal((Object)this.deviceId, (Object)that.deviceId) && Objects.equal((Object)this.deviceOwner, (Object)that.deviceOwner) && Objects.equal(this.fixedIps, that.fixedIps) && Objects.equal((Object)this.macAddress, (Object)that.macAddress);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("state", (Object)this.state).add("adminStateUp", (Object)this.adminStateUp).add("networkId", (Object)this.networkId).add("deviceId", (Object)this.deviceId).add("deviceOwner", (Object)this.deviceOwner).add("fixedIps", this.fixedIps).add("macAddress", (Object)this.macAddress);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    @Override
    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromPort(this);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends ReferenceWithName.Builder<T> {
        protected String networkId;
        protected String deviceId;
        protected String deviceOwner;
        protected String macAddress;
        protected Set<IP> fixedIps;
        protected State state;
        protected Boolean adminStateUp;

        public T state(State state) {
            this.state = state;
            return (T)((Builder)this.self());
        }

        public T networkId(String networkId) {
            this.networkId = networkId;
            return (T)((Builder)this.self());
        }

        public T adminStateUp(Boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return (T)((Builder)this.self());
        }

        public T deviceId(String deviceId) {
            this.deviceId = deviceId;
            return (T)((Builder)this.self());
        }

        public T deviceOwner(String deviceOwner) {
            this.deviceOwner = deviceOwner;
            return (T)((Builder)this.self());
        }

        public T fixedIps(Set<IP> fixedIps) {
            this.fixedIps = fixedIps;
            return (T)((Builder)this.self());
        }

        public T macAddress(String macAddress) {
            this.macAddress = macAddress;
            return (T)((Builder)this.self());
        }

        @Override
        public Port build() {
            return new Port(this.id, this.tenantId, this.name, this.state, this.networkId, this.adminStateUp, this.deviceId, this.deviceOwner, this.fixedIps, this.macAddress);
        }

        public T fromPort(Port in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)super.fromReference(in)).state(in.getState())).networkId(in.getNetworkId())).adminStateUp(in.getAdminStateUp())).deviceId(in.getDeviceId())).deviceOwner(in.getDeviceOwner())).fixedIps(in.getFixedIps())).macAddress(in.getMacAddress());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

