/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;
import org.jclouds.openstack.neutron.v2_0.domain.ExternalGatewayInfo;
import org.jclouds.openstack.neutron.v2_0.domain.ReferenceWithName;
import org.jclouds.openstack.neutron.v2_0.domain.State;

public class Router
extends ReferenceWithName {
    private final Boolean adminStateUp;
    private final State state;
    private final ExternalGatewayInfo externalGatewayInfo;

    @ConstructorProperties(value={"id", "tenant_id", "name", "admin_state_up", "status", "external_gateway_info"})
    protected Router(String id, String tenantId, String name, Boolean adminStateUp, State state, ExternalGatewayInfo externalGatewayInfo) {
        super(id, tenantId, name);
        this.adminStateUp = adminStateUp;
        this.state = state;
        this.externalGatewayInfo = externalGatewayInfo;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public State getState() {
        return this.state;
    }

    public ExternalGatewayInfo getExternalGatewayInfo() {
        return this.externalGatewayInfo;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.adminStateUp, this.state, this.externalGatewayInfo});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Router that = (Router)Router.class.cast(obj);
        return super.equals(obj) && Objects.equal((Object)this.adminStateUp, (Object)that.adminStateUp) && Objects.equal((Object)((Object)this.state), (Object)((Object)that.state)) && Objects.equal((Object)this.externalGatewayInfo, (Object)that.externalGatewayInfo);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("adminStateUp", (Object)this.adminStateUp).add("state", (Object)this.state).add("externalGatewayInfo", (Object)(this.externalGatewayInfo != null ? this.externalGatewayInfo.toString() : ""));
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    @Override
    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromRouter(this);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends ReferenceWithName.Builder<T> {
        protected Boolean adminStateUp;
        protected State state;
        protected ExternalGatewayInfo externalGatewayInfo;

        public T adminStateUp(Boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return (T)((Builder)this.self());
        }

        public T state(State state) {
            this.state = state;
            return (T)((Builder)this.self());
        }

        public T externalGatewayInfo(ExternalGatewayInfo externalGatewayInfo) {
            this.externalGatewayInfo = externalGatewayInfo;
            return (T)((Builder)this.self());
        }

        @Override
        public Router build() {
            return new Router(this.id, this.tenantId, this.name, this.adminStateUp, this.state, this.externalGatewayInfo);
        }

        public T fromRouter(Router in) {
            return ((Builder)((Builder)((Builder)super.fromReference(in)).adminStateUp(in.getAdminStateUp())).state(in.getState())).externalGatewayInfo(in.getExternalGatewayInfo());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

