/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.domain;

import com.google.common.base.Objects;
import java.beans.ConstructorProperties;

public class RouterInterface {
    private final String subnetId;
    private final String portId;

    @ConstructorProperties(value={"subnet_id", "port_id"})
    protected RouterInterface(String subnetId, String portId) {
        this.subnetId = subnetId;
        this.portId = portId;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public String getPortId() {
        return this.portId;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.subnetId, this.portId});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RouterInterface that = (RouterInterface)RouterInterface.class.cast(obj);
        return Objects.equal((Object)this.subnetId, (Object)that.subnetId) && Objects.equal((Object)this.portId, (Object)that.portId);
    }

    protected Objects.ToStringHelper string() {
        return Objects.toStringHelper((Object)this).add("subnetId", (Object)this.subnetId).add("portId", (Object)this.portId);
    }

    public String toString() {
        return this.string().toString();
    }

    public static Builder builder() {
        return new ConcreteBuilder();
    }

    public Builder toBuilder() {
        return new ConcreteBuilder().fromRouterInterface(this);
    }

    public static abstract class Builder {
        protected String subnetId;
        protected String portId;

        protected abstract Builder self();

        public Builder subnetId(String subnetId) {
            this.subnetId = subnetId;
            return this.self();
        }

        public Builder portId(String portId) {
            this.portId = portId;
            return this.self();
        }

        public RouterInterface build() {
            return new RouterInterface(this.subnetId, this.portId);
        }

        public Builder fromRouterInterface(RouterInterface in) {
            return this.subnetId(in.getSubnetId()).portId(in.getPortId());
        }
    }

    private static class ConcreteBuilder
    extends Builder {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

