/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.domain;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Set;
import org.jclouds.openstack.neutron.v2_0.domain.AllocationPool;
import org.jclouds.openstack.neutron.v2_0.domain.HostRoute;
import org.jclouds.openstack.neutron.v2_0.domain.ReferenceWithName;

public class Subnet
extends ReferenceWithName {
    private final String networkId;
    private final String gatewayIp;
    private final Integer ipVersion;
    private final String cidr;
    private final Set<AllocationPool> allocationPools;
    private final Boolean enableDhcp;
    private final Set<String> dnsNameServers;
    private final Set<HostRoute> hostRoutes;

    @ConstructorProperties(value={"id", "tenant_id", "name", "network_id", "gateway_ip", "ip_version", "cidr", "allocation_pools", "enable_dhcp", "dns_nameservers", "host_routes"})
    protected Subnet(String id, String tenantId, String name, String networkId, String gatewayIp, Integer ipVersion, String cidr, Set<AllocationPool> allocationPools, Boolean enableDhcp, Set<String> dnsNameServers, Set<HostRoute> hostRoutes) {
        super(id, tenantId, name);
        this.networkId = (String)Preconditions.checkNotNull((Object)networkId, (Object)"networkId");
        this.gatewayIp = gatewayIp;
        this.ipVersion = (Integer)Preconditions.checkNotNull((Object)ipVersion, (Object)"ipVersion");
        this.cidr = (String)Preconditions.checkNotNull((Object)cidr, (Object)"cidr");
        this.allocationPools = allocationPools != null ? ImmutableSet.copyOf(allocationPools) : ImmutableSet.of();
        this.enableDhcp = enableDhcp;
        this.dnsNameServers = dnsNameServers != null ? ImmutableSet.copyOf(dnsNameServers) : ImmutableSet.of();
        this.hostRoutes = hostRoutes != null ? ImmutableSet.copyOf(hostRoutes) : ImmutableSet.of();
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public String getGatewayIp() {
        return this.gatewayIp;
    }

    public Integer getIpVersion() {
        return this.ipVersion;
    }

    public String getCidr() {
        return this.cidr;
    }

    public Set<AllocationPool> getAllocationPools() {
        return this.allocationPools;
    }

    public Boolean getEnableDhcp() {
        return this.enableDhcp;
    }

    public Set<String> getDnsNameServers() {
        return this.dnsNameServers;
    }

    public Set<HostRoute> getHostRoutes() {
        return this.hostRoutes;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.networkId, this.gatewayIp, this.ipVersion, this.cidr, this.allocationPools, this.enableDhcp, this.dnsNameServers, this.hostRoutes});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Subnet that = (Subnet)Subnet.class.cast(obj);
        return super.equals(obj) && Objects.equal((Object)this.networkId, (Object)that.networkId) && Objects.equal((Object)this.gatewayIp, (Object)that.gatewayIp) && Objects.equal((Object)this.ipVersion, (Object)that.ipVersion) && Objects.equal((Object)this.cidr, (Object)that.cidr) && Objects.equal(this.allocationPools, that.allocationPools) && Objects.equal((Object)this.enableDhcp, (Object)that.enableDhcp) && Objects.equal(this.dnsNameServers, that.dnsNameServers) && Objects.equal(this.hostRoutes, that.hostRoutes);
    }

    @Override
    protected Objects.ToStringHelper string() {
        return super.string().add("networkId", (Object)this.networkId).add("gatewayIp", (Object)this.gatewayIp).add("ipVersion", (Object)this.ipVersion).add("cidr", (Object)this.cidr).add("enableDHCP", (Object)this.enableDhcp).add("allocationPools", this.allocationPools).add("dnsNameServers", this.dnsNameServers).add("hostRoutes", this.hostRoutes);
    }

    @Override
    public String toString() {
        return this.string().toString();
    }

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    @Override
    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromSubnet(this);
    }

    public static abstract class Builder<T extends Builder<T>>
    extends ReferenceWithName.Builder<T> {
        protected String networkId;
        protected String gatewayIp;
        protected Integer ipVersion;
        protected String cidr;
        protected Set<AllocationPool> allocationPools;
        protected Boolean enableDhcp;
        protected Set<String> dnsNameServers;
        protected Set<HostRoute> hostRoutes;

        public T networkId(String networkId) {
            this.networkId = networkId;
            return (T)((Builder)this.self());
        }

        public T gatewayIp(String gatewayIp) {
            this.gatewayIp = gatewayIp;
            return (T)((Builder)this.self());
        }

        public T ipVersion(Integer ipVersion) {
            this.ipVersion = ipVersion;
            return (T)((Builder)this.self());
        }

        public T cidr(String cidr) {
            this.cidr = cidr;
            return (T)((Builder)this.self());
        }

        public T allocationPools(Collection<AllocationPool> allocationPools) {
            this.allocationPools = ImmutableSet.copyOf(allocationPools);
            return (T)((Builder)this.self());
        }

        public T enableDhcp(Boolean enableDhcp) {
            this.enableDhcp = enableDhcp;
            return (T)((Builder)this.self());
        }

        public T dnsNameServers(Collection<String> dnsNameServers) {
            this.dnsNameServers = ImmutableSet.copyOf(dnsNameServers);
            return (T)((Builder)this.self());
        }

        public T hostRoutes(Collection<HostRoute> hostRoutes) {
            this.hostRoutes = ImmutableSet.copyOf(hostRoutes);
            return (T)((Builder)this.self());
        }

        @Override
        public Subnet build() {
            return new Subnet(this.id, this.tenantId, this.name, this.networkId, this.gatewayIp, this.ipVersion, this.cidr, this.allocationPools, this.enableDhcp, this.dnsNameServers, this.hostRoutes);
        }

        public T fromSubnet(Subnet in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)super.fromReference(in)).networkId(in.getNetworkId())).gatewayIp(in.getGatewayIp())).ipVersion(in.getIpVersion())).cidr(in.getCidr())).allocationPools(in.getAllocationPools())).enableDhcp(in.getEnableDhcp())).dnsNameServers(in.getDnsNameServers())).hostRoutes(in.getHostRoutes());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

