/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.functions;

import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.inject.TypeLiteral;
import java.beans.ConstructorProperties;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.collect.IterableWithMarker;
import org.jclouds.collect.internal.Arg0ToPagedIterable;
import org.jclouds.http.functions.ParseJson;
import org.jclouds.json.Json;
import org.jclouds.openstack.neutron.v2_0.NeutronApi;
import org.jclouds.openstack.neutron.v2_0.domain.Network;
import org.jclouds.openstack.neutron.v2_0.features.NetworkApi;
import org.jclouds.openstack.v2_0.domain.Link;
import org.jclouds.openstack.v2_0.domain.PaginatedCollection;
import org.jclouds.openstack.v2_0.options.PaginationOptions;

@Singleton
@Beta
public class ParseNetworkDetails
extends ParseJson<Networks> {
    @Inject
    public ParseNetworkDetails(Json json) {
        super(json, TypeLiteral.get(Networks.class));
    }

    static class Networks
    extends PaginatedCollection<Network> {
        @ConstructorProperties(value={"networks", "networks_links"})
        protected Networks(Iterable<Network> networks, Iterable<Link> networksLinks) {
            super(networks, networksLinks);
        }
    }

    public static class ToPagedIterable
    extends Arg0ToPagedIterable.FromCaller<Network, ToPagedIterable> {
        private final NeutronApi api;

        @Inject
        protected ToPagedIterable(NeutronApi api) {
            this.api = (NeutronApi)Preconditions.checkNotNull((Object)api, (Object)"api");
        }

        protected Function<Object, IterableWithMarker<Network>> markerToNextForArg0(Optional<Object> arg0) {
            String zone = arg0.isPresent() ? arg0.get().toString() : null;
            final NetworkApi networkApi = this.api.getNetworkApiForZone(zone);
            return new Function<Object, IterableWithMarker<Network>>(){

                public IterableWithMarker<Network> apply(Object input) {
                    PaginationOptions paginationOptions = (PaginationOptions)PaginationOptions.class.cast(input);
                    return (IterableWithMarker)IterableWithMarker.class.cast(networkApi.listInDetail(paginationOptions));
                }

                public String toString() {
                    return "listNetworksInDetail()";
                }
            };
        }
    }
}

