/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.neutron.v2_0.domain.BulkNetwork;
import org.jclouds.openstack.neutron.v2_0.domain.NetworkType;
import org.jclouds.openstack.neutron.v2_0.options.CreateNetworkOptions;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateNetworkBulkOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private final List<BulkNetwork> networks;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromCreateNetworkOptions(this);
    }

    protected CreateNetworkBulkOptions() {
        this.networks = Lists.newArrayList();
    }

    public CreateNetworkBulkOptions(List<BulkNetwork> networks) {
        this.networks = networks != null ? ImmutableList.copyOf(networks) : Lists.newArrayList();
    }

    public List<BulkNetwork> getNetworks() {
        return this.networks;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        ArrayList createNetworkRequests = Lists.newArrayList();
        for (BulkNetwork network : this.networks) {
            if (network.getNetworkType() != null) {
                if (network.getNetworkType() == NetworkType.FLAT) {
                    Preconditions.checkNotNull((Object)network.getPhysicalNetworkName(), (Object)"physicalNetworkName must be present when networkType=FLAT");
                } else if (network.getNetworkType() == NetworkType.VLAN) {
                    Preconditions.checkNotNull((Object)network.getPhysicalNetworkName(), (Object)"physicalNetworkName must be present when networkType=VLAN");
                    Preconditions.checkNotNull((Object)network.getSegmentationId(), (Object)"segmentationId must be present when networkType=VLAN");
                } else if (network.getNetworkType() == NetworkType.GRE) {
                    Preconditions.checkNotNull((Object)network.getSegmentationId(), (Object)"segmentationId must be present when NetworkType=GRE");
                }
            }
            CreateNetworkOptions.CreateNetworkRequest createNetworkRequest = new CreateNetworkOptions.CreateNetworkRequest();
            if (network.getName() != null) {
                createNetworkRequest.name = network.getName();
            }
            if (network.getAdminStateUp() != null) {
                createNetworkRequest.admin_state_up = network.getAdminStateUp();
            }
            if (network.getExternal() != null) {
                createNetworkRequest.external = network.getExternal();
            }
            if (network.getNetworkType() != null) {
                createNetworkRequest.networkType = network.getNetworkType().getValue();
            }
            if (network.getPhysicalNetworkName() != null && (network.getNetworkType() == NetworkType.FLAT || network.getNetworkType() == NetworkType.VLAN)) {
                createNetworkRequest.physicalNetworkName = network.getPhysicalNetworkName();
            }
            if (network.getSegmentationId() != null && (network.getNetworkType() == NetworkType.VLAN || network.getNetworkType() == NetworkType.GRE)) {
                createNetworkRequest.segmentationId = network.getSegmentationId();
            }
            createNetworkRequests.add(createNetworkRequest);
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"networks", (Object)createNetworkRequests));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected List<BulkNetwork> networks;

        protected abstract T self();

        public T networks(Collection<BulkNetwork> networks) {
            this.networks = ImmutableList.copyOf(networks);
            return this.self();
        }

        public CreateNetworkBulkOptions build() {
            return new CreateNetworkBulkOptions(this.networks);
        }

        public T fromCreateNetworkOptions(CreateNetworkBulkOptions in) {
            return this.networks(in.getNetworks());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }
}

