/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.gson.annotations.SerializedName;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.neutron.v2_0.domain.NetworkType;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateNetworkOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private final String name;
    private final Boolean adminStateUp;
    private final Boolean external;
    private final NetworkType networkType;
    private final String physicalNetworkName;
    private final Integer segmentationId;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromCreateNetworkOptions(this);
    }

    protected CreateNetworkOptions() {
        this.name = null;
        this.adminStateUp = null;
        this.external = null;
        this.networkType = null;
        this.physicalNetworkName = null;
        this.segmentationId = null;
    }

    public CreateNetworkOptions(String name, Boolean adminStateUp, Boolean external, NetworkType networkType, String physicalNetworkName, Integer segmentationId) {
        this.name = name;
        this.adminStateUp = adminStateUp;
        this.external = external;
        this.networkType = networkType;
        this.physicalNetworkName = physicalNetworkName;
        this.segmentationId = segmentationId;
    }

    public String getName() {
        return this.name;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public Boolean getExternal() {
        return this.external;
    }

    public NetworkType getNetworkType() {
        return this.networkType;
    }

    public String getPhysicalNetworkName() {
        return this.physicalNetworkName;
    }

    public Integer getSegmentationId() {
        return this.segmentationId;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        if (this.networkType != null) {
            if (this.networkType == NetworkType.FLAT) {
                Preconditions.checkNotNull((Object)this.physicalNetworkName, (Object)"physicalNetworkName must be present when networkType=FLAT");
            } else if (this.networkType == NetworkType.VLAN) {
                Preconditions.checkNotNull((Object)this.physicalNetworkName, (Object)"physicalNetworkName must be present when networkType=VLAN");
                Preconditions.checkNotNull((Object)this.segmentationId, (Object)"segmentationId must be present when networkType=VLAN");
            } else if (this.networkType == NetworkType.GRE) {
                Preconditions.checkNotNull((Object)this.segmentationId, (Object)"segmentationId must be present when NetworkType=GRE");
            }
        }
        CreateNetworkRequest createNetworkRequest = new CreateNetworkRequest();
        if (this.name != null) {
            createNetworkRequest.name = this.name;
        }
        if (this.adminStateUp != null) {
            createNetworkRequest.admin_state_up = this.adminStateUp;
        }
        if (this.external != null) {
            createNetworkRequest.external = this.external;
        }
        if (this.networkType != null) {
            createNetworkRequest.networkType = this.networkType.getValue();
        }
        if (this.physicalNetworkName != null && (this.networkType == NetworkType.FLAT || this.networkType == NetworkType.VLAN)) {
            createNetworkRequest.physicalNetworkName = this.physicalNetworkName;
        }
        if (this.segmentationId != null && (this.networkType == NetworkType.VLAN || this.networkType == NetworkType.GRE)) {
            createNetworkRequest.segmentationId = this.segmentationId;
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"network", (Object)createNetworkRequest));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected Boolean adminStateUp;
        protected Boolean external;
        protected NetworkType networkType;
        protected String physicalNetworkName;
        protected Integer segmentationId;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T adminStateUp(Boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return this.self();
        }

        public T external(Boolean external) {
            this.external = external;
            return this.self();
        }

        public T networkType(NetworkType networkType) {
            this.networkType = networkType;
            return this.self();
        }

        public T physicalNetworkName(String physicalNetworkName) {
            this.physicalNetworkName = physicalNetworkName;
            return this.self();
        }

        public T segmentationId(Integer segmentationId) {
            this.segmentationId = segmentationId;
            return this.self();
        }

        public CreateNetworkOptions build() {
            return new CreateNetworkOptions(this.name, this.adminStateUp, this.external, this.networkType, this.physicalNetworkName, this.segmentationId);
        }

        public T fromCreateNetworkOptions(CreateNetworkOptions in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.name(in.getName())).adminStateUp(in.getAdminStateUp())).external(in.getExternal())).networkType(in.getNetworkType())).physicalNetworkName(in.getPhysicalNetworkName())).segmentationId(in.getSegmentationId());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    protected static class CreateNetworkRequest {
        protected String name;
        protected Boolean admin_state_up;
        @SerializedName(value="router:external")
        protected Boolean external;
        @SerializedName(value="provider:network_type")
        protected String networkType;
        @SerializedName(value="provider:physical_network")
        protected String physicalNetworkName;
        @SerializedName(value="provider:segmentation_id")
        protected Integer segmentationId;

        protected CreateNetworkRequest() {
        }
    }
}

