/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.neutron.v2_0.domain.IP;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreatePortOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private final String name;
    private final String deviceId;
    private final String deviceOwner;
    private final String macAddress;
    private final Set<IP> fixedIps;
    private final Boolean adminStateUp;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromCreatePortOptions(this);
    }

    protected CreatePortOptions() {
        this.name = null;
        this.deviceId = null;
        this.deviceOwner = null;
        this.macAddress = null;
        this.fixedIps = Sets.newHashSet();
        this.adminStateUp = null;
    }

    public CreatePortOptions(String name, String deviceId, String deviceOwner, String macAddress, Set<IP> fixedIps, Boolean adminStateUp) {
        this.name = name;
        this.deviceId = deviceId;
        this.deviceOwner = deviceOwner;
        this.macAddress = macAddress;
        this.fixedIps = fixedIps != null ? ImmutableSet.copyOf(fixedIps) : Sets.newHashSet();
        this.adminStateUp = adminStateUp;
    }

    public String getName() {
        return this.name;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceOwner() {
        return this.deviceOwner;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public Set<IP> getFixedIps() {
        return this.fixedIps;
    }

    public Boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        CreatePortRequest createPortRequest = new CreatePortRequest(Preconditions.checkNotNull((Object)postParams.get("network_id"), (Object)"networkId not present").toString());
        if (this.name != null) {
            createPortRequest.name = this.name;
        }
        if (this.deviceId != null) {
            createPortRequest.device_id = this.deviceId;
        }
        if (this.deviceOwner != null) {
            createPortRequest.device_owner = this.deviceOwner;
        }
        if (this.macAddress != null) {
            createPortRequest.mac_address = this.macAddress;
        }
        if (!this.fixedIps.isEmpty()) {
            createPortRequest.fixed_ips = Sets.newHashSet();
            for (IP ip : this.fixedIps) {
                CreatePortRequest.IP requestIp = new CreatePortRequest.IP();
                requestIp.subnet_id = ip.getSubnetId();
                requestIp.ip_address = ip.getIpAddress();
                createPortRequest.fixed_ips.add(requestIp);
            }
        }
        if (this.adminStateUp != null) {
            createPortRequest.admin_state_up = this.adminStateUp;
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"port", (Object)createPortRequest));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected String deviceId;
        protected String deviceOwner;
        protected String macAddress;
        protected Set<IP> fixedIps;
        protected Boolean adminStateUp;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T deviceId(String deviceId) {
            this.deviceId = deviceId;
            return this.self();
        }

        public T deviceOwner(String deviceOwner) {
            this.deviceOwner = deviceOwner;
            return this.self();
        }

        public T macAddress(String macAddress) {
            this.macAddress = macAddress;
            return this.self();
        }

        public T fixedIps(Set<IP> fixedIps) {
            this.fixedIps = fixedIps;
            return this.self();
        }

        public T adminStateUp(Boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return this.self();
        }

        public CreatePortOptions build() {
            return new CreatePortOptions(this.name, this.deviceId, this.deviceOwner, this.macAddress, this.fixedIps, this.adminStateUp);
        }

        public T fromCreatePortOptions(CreatePortOptions options) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.name(options.getName())).deviceId(options.getDeviceId())).deviceOwner(options.getDeviceOwner())).macAddress(options.getMacAddress())).fixedIps(options.getFixedIps())).adminStateUp(options.getAdminStateUp());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    protected static class CreatePortRequest {
        protected String network_id;
        protected String name;
        protected String device_id;
        protected String device_owner;
        protected String mac_address;
        protected Set<IP> fixed_ips;
        protected Boolean admin_state_up;

        protected CreatePortRequest(String networkId) {
            this.network_id = networkId;
        }

        protected static final class IP {
            protected String ip_address;
            protected String subnet_id;

            protected IP() {
            }
        }
    }
}

