/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.options;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.openstack.neutron.v2_0.domain.AllocationPool;
import org.jclouds.openstack.neutron.v2_0.domain.HostRoute;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class CreateSubnetOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private final String name;
    private final Set<AllocationPool> allocationPools;
    private final String gatewayIp;
    private final Boolean enableDhcp;
    private final Set<String> dnsNameServers;
    private final Set<HostRoute> hostRoutes;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromCreateSubnetOptions(this);
    }

    protected CreateSubnetOptions() {
        this.name = null;
        this.allocationPools = Sets.newHashSet();
        this.gatewayIp = null;
        this.enableDhcp = null;
        this.dnsNameServers = Sets.newHashSet();
        this.hostRoutes = Sets.newHashSet();
    }

    public CreateSubnetOptions(String name, Set<AllocationPool> allocationPools, String gatewayIp, Boolean enableDhcp, Set<String> dnsNameServers, Set<HostRoute> hostRoutes) {
        this.name = name;
        this.allocationPools = allocationPools != null ? ImmutableSet.copyOf(allocationPools) : Sets.newHashSet();
        this.gatewayIp = gatewayIp;
        this.enableDhcp = enableDhcp;
        this.dnsNameServers = dnsNameServers != null ? ImmutableSet.copyOf(dnsNameServers) : Sets.newHashSet();
        this.hostRoutes = hostRoutes != null ? ImmutableSet.copyOf(hostRoutes) : Sets.newHashSet();
    }

    public String getName() {
        return this.name;
    }

    public Set<AllocationPool> getAllocationPools() {
        return this.allocationPools;
    }

    public String getGatewayIp() {
        return this.gatewayIp;
    }

    public Boolean getEnableDhcp() {
        return this.enableDhcp;
    }

    public Set<String> getDnsNameServers() {
        return this.dnsNameServers;
    }

    public Set<HostRoute> getHostRoutes() {
        return this.hostRoutes;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        CreateSubnetRequest createSubnetRequest = new CreateSubnetRequest(Preconditions.checkNotNull((Object)postParams.get("network_id"), (Object)"networkId not present").toString(), Integer.parseInt(Preconditions.checkNotNull((Object)postParams.get("ip_version"), (Object)"ipVersion not present").toString()), Preconditions.checkNotNull((Object)postParams.get("cidr"), (Object)"cidr not present").toString());
        if (this.name != null) {
            createSubnetRequest.name = this.name;
        }
        if (!this.allocationPools.isEmpty()) {
            createSubnetRequest.allocation_pools = this.allocationPools;
        }
        if (this.gatewayIp != null) {
            createSubnetRequest.gateway_ip = this.gatewayIp;
        }
        if (this.enableDhcp != null) {
            createSubnetRequest.enable_dhcp = this.enableDhcp;
        }
        if (!this.dnsNameServers.isEmpty()) {
            createSubnetRequest.dns_nameservers = this.dnsNameServers;
        }
        if (!this.hostRoutes.isEmpty()) {
            createSubnetRequest.host_routes = Sets.newHashSet();
            for (HostRoute hostRoute : this.hostRoutes) {
                CreateSubnetRequest.HostRoute requestHostRoute = new CreateSubnetRequest.HostRoute();
                requestHostRoute.destination = hostRoute.getDestinationCidr();
                requestHostRoute.nexthop = hostRoute.getNextHop();
                createSubnetRequest.host_routes.add(requestHostRoute);
            }
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"subnet", (Object)createSubnetRequest));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected Set<AllocationPool> allocationPools;
        protected String gatewayIp;
        protected Boolean enableDhcp;
        protected Set<String> dnsNameServers;
        protected Set<HostRoute> hostRoutes;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T allocationPools(Collection<AllocationPool> allocationPools) {
            this.allocationPools = ImmutableSet.copyOf(allocationPools);
            return this.self();
        }

        public T gatewayIp(String gatewayIp) {
            this.gatewayIp = gatewayIp;
            return this.self();
        }

        public T enableDhcp(Boolean enableDhcp) {
            this.enableDhcp = enableDhcp;
            return this.self();
        }

        public T dnsNameServers(Collection<String> dnsNameServers) {
            this.dnsNameServers = ImmutableSet.copyOf(dnsNameServers);
            return this.self();
        }

        public T hostRoutes(Collection<HostRoute> hostRoutes) {
            this.hostRoutes = ImmutableSet.copyOf(hostRoutes);
            return this.self();
        }

        public CreateSubnetOptions build() {
            return new CreateSubnetOptions(this.name, this.allocationPools, this.gatewayIp, this.enableDhcp, this.dnsNameServers, this.hostRoutes);
        }

        public T fromCreateSubnetOptions(CreateSubnetOptions in) {
            return ((Builder)((Builder)((Builder)((Builder)((Builder)this.name(in.getName())).allocationPools(in.getAllocationPools())).gatewayIp(in.getGatewayIp())).enableDhcp(in.getEnableDhcp())).dnsNameServers(in.getDnsNameServers())).hostRoutes(in.getHostRoutes());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    protected static class CreateSubnetRequest {
        protected String network_id;
        protected Integer ip_version;
        protected String cidr;
        protected String name;
        protected Set<AllocationPool> allocation_pools;
        protected String gateway_ip;
        protected Boolean enable_dhcp;
        protected Set<String> dns_nameservers;
        protected Set<HostRoute> host_routes;

        protected CreateSubnetRequest(String networkId, Integer ipVersion, String cidr) {
            this.network_id = networkId;
            this.ip_version = ipVersion;
            this.cidr = cidr;
        }

        protected static class HostRoute {
            protected String destination;
            protected String nexthop;

            protected HostRoute() {
            }
        }
    }
}

