/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.openstack.neutron.v2_0.options;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.inject.Inject;
import org.jclouds.http.HttpRequest;
import org.jclouds.rest.MapBinder;
import org.jclouds.rest.binders.BindToJsonPayload;

public class UpdateNetworkOptions
implements MapBinder {
    @Inject
    private BindToJsonPayload jsonBinder;
    private final String name;
    private final Boolean adminStateUp;

    public static Builder<?> builder() {
        return new ConcreteBuilder();
    }

    public Builder<?> toBuilder() {
        return new ConcreteBuilder().fromUpdateNetworkOptions(this);
    }

    protected UpdateNetworkOptions() {
        this.name = null;
        this.adminStateUp = null;
    }

    public UpdateNetworkOptions(String name, Boolean adminStateUp) {
        this.name = name;
        this.adminStateUp = adminStateUp;
    }

    public String getName() {
        return this.name;
    }

    public boolean getAdminStateUp() {
        return this.adminStateUp;
    }

    public <R extends HttpRequest> R bindToRequest(R request, Map<String, Object> postParams) {
        UpdateNetworkRequest updateNetworkRequest = new UpdateNetworkRequest();
        if (this.name != null) {
            updateNetworkRequest.name = this.name;
        }
        if (this.adminStateUp != null) {
            updateNetworkRequest.admin_state_up = this.adminStateUp;
        }
        return this.bindToRequest(request, ImmutableMap.of((Object)"network", (Object)updateNetworkRequest));
    }

    public <R extends HttpRequest> R bindToRequest(R request, Object input) {
        return (R)this.jsonBinder.bindToRequest(request, input);
    }

    public static abstract class Builder<T extends Builder<T>> {
        protected String name;
        protected Boolean adminStateUp;

        protected abstract T self();

        public T name(String name) {
            this.name = name;
            return this.self();
        }

        public T adminStateUp(Boolean adminStateUp) {
            this.adminStateUp = adminStateUp;
            return this.self();
        }

        public UpdateNetworkOptions build() {
            return new UpdateNetworkOptions(this.name, this.adminStateUp);
        }

        public T fromUpdateNetworkOptions(UpdateNetworkOptions options) {
            return ((Builder)this.name(options.getName())).adminStateUp(options.getAdminStateUp());
        }
    }

    private static class ConcreteBuilder
    extends Builder<ConcreteBuilder> {
        private ConcreteBuilder() {
        }

        @Override
        protected ConcreteBuilder self() {
            return this;
        }
    }

    private static class UpdateNetworkRequest {
        protected String name;
        protected Boolean admin_state_up;

        private UpdateNetworkRequest() {
        }
    }
}

