/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConjunctionDISI;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class FilteredQuery
extends Query {
    private final Query query;
    private final Filter filter;
    private final FilterStrategy strategy;
    public static final FilterStrategy RANDOM_ACCESS_FILTER_STRATEGY = new RandomAccessFilterStrategy();
    public static final FilterStrategy LEAP_FROG_FILTER_FIRST_STRATEGY = new LeapFrogFilterStrategy(false);
    public static final FilterStrategy LEAP_FROG_QUERY_FIRST_STRATEGY = new LeapFrogFilterStrategy(true);
    public static final FilterStrategy QUERY_FIRST_FILTER_STRATEGY = new QueryFirstFilterStrategy();

    public FilteredQuery(Query query, Filter filter) {
        this(query, filter, RANDOM_ACCESS_FILTER_STRATEGY);
    }

    public FilteredQuery(Query query, Filter filter, FilterStrategy strategy) {
        this.strategy = Objects.requireNonNull(strategy, "FilterStrategy must not be null");
        this.query = Objects.requireNonNull(query, "Query must not be null");
        this.filter = Objects.requireNonNull(filter, "Filter must not be null");
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        final Weight weight = this.query.createWeight(searcher, needsScores);
        return new Weight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
                weight.extractTerms(terms);
            }

            @Override
            public float getValueForNormalization() throws IOException {
                return weight.getValueForNormalization() * FilteredQuery.this.getBoost() * FilteredQuery.this.getBoost();
            }

            @Override
            public void normalize(float norm, float topLevelBoost) {
                weight.normalize(norm, topLevelBoost * FilteredQuery.this.getBoost());
            }

            @Override
            public Explanation explain(LeafReaderContext ir, int i) throws IOException {
                DocIdSetIterator docIdSetIterator;
                Explanation inner = weight.explain(ir, i);
                Filter f = FilteredQuery.this.filter;
                DocIdSet docIdSet = f.getDocIdSet(ir, ir.reader().getLiveDocs());
                DocIdSetIterator docIdSetIterator2 = docIdSetIterator = docIdSet == null ? DocIdSetIterator.empty() : docIdSet.iterator();
                if (docIdSetIterator == null) {
                    docIdSetIterator = DocIdSetIterator.empty();
                }
                if (docIdSetIterator.advance(i) == i) {
                    return inner;
                }
                return Explanation.noMatch("failure to match filter: " + f.toString(), inner);
            }

            @Override
            public Scorer scorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                assert (FilteredQuery.this.filter != null);
                DocIdSet filterDocIdSet = FilteredQuery.this.filter.getDocIdSet(context, acceptDocs);
                if (filterDocIdSet == null) {
                    return null;
                }
                return FilteredQuery.this.strategy.filteredScorer(context, weight, filterDocIdSet);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext context, Bits acceptDocs) throws IOException {
                assert (FilteredQuery.this.filter != null);
                DocIdSet filterDocIdSet = FilteredQuery.this.filter.getDocIdSet(context, acceptDocs);
                if (filterDocIdSet == null) {
                    return null;
                }
                return FilteredQuery.this.strategy.filteredBulkScorer(context, weight, filterDocIdSet);
            }
        };
    }

    @Override
    public Query rewrite(IndexReader reader) throws IOException {
        Query queryRewritten = this.query.rewrite(reader);
        Query filterRewritten = this.filter.rewrite(reader);
        if (queryRewritten != this.query || filterRewritten != this.filter) {
            if (filterRewritten instanceof Filter) {
                FilteredQuery rewritten = new FilteredQuery(queryRewritten, (Filter)filterRewritten, this.strategy);
                rewritten.setBoost(this.getBoost());
                return rewritten;
            }
            BooleanQuery rewritten = new BooleanQuery();
            rewritten.add(queryRewritten, BooleanClause.Occur.MUST);
            rewritten.add(filterRewritten, BooleanClause.Occur.FILTER);
            rewritten.setBoost(this.getBoost());
            return rewritten;
        }
        return this;
    }

    public final Query getQuery() {
        return this.query;
    }

    public final Filter getFilter() {
        return this.filter;
    }

    public FilterStrategy getFilterStrategy() {
        return this.strategy;
    }

    @Override
    public String toString(String s) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("filtered(");
        buffer.append(this.query.toString(s));
        buffer.append(")->");
        buffer.append(this.filter);
        buffer.append(ToStringUtils.boost(this.getBoost()));
        return buffer.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        assert (o instanceof FilteredQuery);
        FilteredQuery fq = (FilteredQuery)o;
        return fq.query.equals(this.query) && fq.filter.equals(this.filter) && fq.strategy.equals(this.strategy);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = hash * 31 + this.strategy.hashCode();
        hash = hash * 31 + this.query.hashCode();
        hash = hash * 31 + this.filter.hashCode();
        return hash;
    }

    public static abstract class FilterStrategy {
        public abstract Scorer filteredScorer(LeafReaderContext var1, Weight var2, DocIdSet var3) throws IOException;

        public BulkScorer filteredBulkScorer(LeafReaderContext context, Weight weight, DocIdSet docIdSet) throws IOException {
            Scorer scorer = this.filteredScorer(context, weight, docIdSet);
            if (scorer == null) {
                return null;
            }
            return new Weight.DefaultBulkScorer(scorer);
        }
    }

    private static final class LeapFrogFilterStrategy
    extends FilterStrategy {
        private final boolean scorerFirst;

        private LeapFrogFilterStrategy(boolean scorerFirst) {
            this.scorerFirst = scorerFirst;
        }

        @Override
        public Scorer filteredScorer(LeafReaderContext context, Weight weight, DocIdSet docIdSet) throws IOException {
            DocIdSetIterator filterIter = docIdSet.iterator();
            if (filterIter == null) {
                return null;
            }
            Scorer scorer = weight.scorer(context, null);
            if (scorer == null) {
                return null;
            }
            if (this.scorerFirst) {
                return new LeapFrogScorer(weight, scorer, filterIter, scorer);
            }
            return new LeapFrogScorer(weight, filterIter, scorer, scorer);
        }
    }

    private static final class LeapFrogScorer
    extends Scorer {
        private final ConjunctionDISI conjunction;
        private final Scorer scorer;

        protected LeapFrogScorer(Weight weight, DocIdSetIterator primary, DocIdSetIterator secondary, Scorer scorer) {
            super(weight);
            this.conjunction = ConjunctionDISI.intersect(Arrays.asList(primary, secondary));
            this.scorer = scorer;
        }

        @Override
        public int nextDoc() throws IOException {
            return this.conjunction.nextDoc();
        }

        @Override
        public final int advance(int target) throws IOException {
            return this.conjunction.advance(target);
        }

        @Override
        public final int docID() {
            return this.conjunction.docID();
        }

        @Override
        public final Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.scorer, "FILTERED"));
        }

        @Override
        public long cost() {
            return this.conjunction.cost();
        }

        @Override
        public float score() throws IOException {
            return this.scorer.score();
        }

        @Override
        public int freq() throws IOException {
            return this.scorer.freq();
        }

        @Override
        public TwoPhaseIterator asTwoPhaseIterator() {
            return this.conjunction.asTwoPhaseIterator();
        }
    }

    private static class QueryFirstBulkScorer
    extends BulkScorer {
        private final Scorer scorer;
        private final Bits filterBits;

        public QueryFirstBulkScorer(Scorer scorer, Bits filterBits) {
            this.scorer = scorer;
            this.filterBits = filterBits;
        }

        @Override
        public long cost() {
            return this.scorer.cost();
        }

        @Override
        public int score(LeafCollector collector, int min, int maxDoc) throws IOException {
            int scorerDoc;
            collector.setScorer(this.scorer);
            if (this.scorer.docID() < min) {
                this.scorer.advance(min);
            }
            while ((scorerDoc = this.scorer.docID()) < maxDoc) {
                if (this.filterBits.get(scorerDoc)) {
                    collector.collect(scorerDoc);
                }
                this.scorer.nextDoc();
            }
            return this.scorer.docID();
        }
    }

    private static final class QueryFirstFilterStrategy
    extends FilterStrategy {
        private QueryFirstFilterStrategy() {
        }

        @Override
        public Scorer filteredScorer(LeafReaderContext context, Weight weight, DocIdSet docIdSet) throws IOException {
            Bits filterAcceptDocs = docIdSet.bits();
            if (filterAcceptDocs == null) {
                return LEAP_FROG_QUERY_FIRST_STRATEGY.filteredScorer(context, weight, docIdSet);
            }
            Scorer scorer = weight.scorer(context, null);
            return scorer == null ? null : new QueryFirstScorer(weight, filterAcceptDocs, scorer);
        }

        @Override
        public BulkScorer filteredBulkScorer(LeafReaderContext context, Weight weight, DocIdSet docIdSet) throws IOException {
            Bits filterAcceptDocs = docIdSet.bits();
            if (filterAcceptDocs == null) {
                return LEAP_FROG_QUERY_FIRST_STRATEGY.filteredBulkScorer(context, weight, docIdSet);
            }
            Scorer scorer = weight.scorer(context, null);
            return scorer == null ? null : new QueryFirstBulkScorer(scorer, filterAcceptDocs);
        }
    }

    private static final class QueryFirstScorer
    extends Scorer {
        private final Scorer scorer;
        private final Bits filterBits;

        protected QueryFirstScorer(Weight weight, Bits filterBits, Scorer other) {
            super(weight);
            this.scorer = other;
            this.filterBits = filterBits;
        }

        @Override
        public int nextDoc() throws IOException {
            int doc;
            while ((doc = this.scorer.nextDoc()) != Integer.MAX_VALUE && !this.filterBits.get(doc)) {
            }
            return doc;
        }

        @Override
        public int advance(int target) throws IOException {
            int doc = this.scorer.advance(target);
            if (doc != Integer.MAX_VALUE && !this.filterBits.get(doc)) {
                return this.nextDoc();
            }
            return doc;
        }

        @Override
        public int docID() {
            return this.scorer.docID();
        }

        @Override
        public float score() throws IOException {
            return this.scorer.score();
        }

        @Override
        public int freq() throws IOException {
            return this.scorer.freq();
        }

        @Override
        public long cost() {
            return this.scorer.cost();
        }

        @Override
        public Collection<Scorer.ChildScorer> getChildren() {
            return Collections.singleton(new Scorer.ChildScorer(this.scorer, "FILTERED"));
        }

        @Override
        public TwoPhaseIterator asTwoPhaseIterator() {
            final TwoPhaseIterator inner = this.scorer.asTwoPhaseIterator();
            if (inner != null) {
                return new TwoPhaseIterator(inner.approximation()){

                    @Override
                    public boolean matches() throws IOException {
                        return inner.matches() && QueryFirstScorer.this.filterBits.get(QueryFirstScorer.this.scorer.docID());
                    }
                };
            }
            return new TwoPhaseIterator(this.scorer){

                @Override
                public boolean matches() throws IOException {
                    return QueryFirstScorer.this.filterBits.get(QueryFirstScorer.this.scorer.docID());
                }
            };
        }
    }

    public static class RandomAccessFilterStrategy
    extends FilterStrategy {
        @Override
        public Scorer filteredScorer(LeafReaderContext context, Weight weight, DocIdSet docIdSet) throws IOException {
            boolean useRandomAccess;
            DocIdSetIterator filterIter = docIdSet.iterator();
            if (filterIter == null) {
                return null;
            }
            Bits filterAcceptDocs = docIdSet.bits();
            boolean bl = useRandomAccess = filterAcceptDocs != null && this.useRandomAccess(filterAcceptDocs, filterIter.cost());
            if (useRandomAccess) {
                return weight.scorer(context, filterAcceptDocs);
            }
            Scorer scorer = weight.scorer(context, null);
            return scorer == null ? null : new LeapFrogScorer(weight, filterIter, scorer, scorer);
        }

        protected boolean useRandomAccess(Bits bits, long filterCost) {
            return filterCost * 100L > (long)bits.length();
        }
    }
}

