/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermState;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.MultiTermQueryConstantScoreWrapper;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoringRewrite;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopTermsRewrite;
import org.apache.lucene.util.AttributeSource;

public abstract class MultiTermQuery
extends Query {
    protected final String field;
    protected RewriteMethod rewriteMethod = CONSTANT_SCORE_REWRITE;
    public static final RewriteMethod CONSTANT_SCORE_REWRITE;
    @Deprecated
    public static final RewriteMethod CONSTANT_SCORE_FILTER_REWRITE;
    public static final RewriteMethod SCORING_BOOLEAN_REWRITE;
    @Deprecated
    public static final RewriteMethod SCORING_BOOLEAN_QUERY_REWRITE;
    public static final RewriteMethod CONSTANT_SCORE_BOOLEAN_REWRITE;
    @Deprecated
    public static final RewriteMethod CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE;

    private static TermContext adjustFrequencies(TermContext ctx, int artificialDf, long artificialTtf) {
        List<LeafReaderContext> leaves = ctx.topReaderContext.leaves();
        int len = leaves == null ? 1 : leaves.size();
        TermContext newCtx = new TermContext(ctx.topReaderContext);
        for (int i = 0; i < len; ++i) {
            TermState termState = ctx.get(i);
            if (termState == null) continue;
            newCtx.register(termState, i);
        }
        newCtx.accumulateStatistics(artificialDf, artificialTtf);
        return newCtx;
    }

    public MultiTermQuery(String field) {
        this.field = Objects.requireNonNull(field, "field must not be null");
    }

    public final String getField() {
        return this.field;
    }

    protected abstract TermsEnum getTermsEnum(Terms var1, AttributeSource var2) throws IOException;

    protected final TermsEnum getTermsEnum(Terms terms) throws IOException {
        return this.getTermsEnum(terms, new AttributeSource());
    }

    @Override
    public final Query rewrite(IndexReader reader) throws IOException {
        return this.rewriteMethod.rewrite(reader, this);
    }

    public RewriteMethod getRewriteMethod() {
        return this.rewriteMethod;
    }

    public void setRewriteMethod(RewriteMethod method) {
        this.rewriteMethod = method;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.getBoost());
        result = 31 * result + this.rewriteMethod.hashCode();
        if (this.field != null) {
            result = 31 * result + this.field.hashCode();
        }
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiTermQuery other = (MultiTermQuery)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (!this.rewriteMethod.equals(other.rewriteMethod)) {
            return false;
        }
        return other.field == null ? this.field == null : other.field.equals(this.field);
    }

    static {
        CONSTANT_SCORE_FILTER_REWRITE = CONSTANT_SCORE_REWRITE = new RewriteMethod(){

            @Override
            public Query rewrite(IndexReader reader, MultiTermQuery query) {
                MultiTermQueryConstantScoreWrapper<MultiTermQuery> result = new MultiTermQueryConstantScoreWrapper<MultiTermQuery>(query);
                result.setBoost(query.getBoost());
                return result;
            }
        };
        SCORING_BOOLEAN_REWRITE = ScoringRewrite.SCORING_BOOLEAN_REWRITE;
        SCORING_BOOLEAN_QUERY_REWRITE = SCORING_BOOLEAN_REWRITE;
        CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE = CONSTANT_SCORE_BOOLEAN_REWRITE = ScoringRewrite.CONSTANT_SCORE_BOOLEAN_REWRITE;
    }

    public static abstract class RewriteMethod {
        public abstract Query rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;

        protected TermsEnum getTermsEnum(MultiTermQuery query, Terms terms, AttributeSource atts) throws IOException {
            return query.getTermsEnum(terms, atts);
        }
    }

    public static final class TopTermsBlendedFreqScoringRewrite
    extends TopTermsRewrite<BooleanQuery> {
        public TopTermsBlendedFreqScoringRewrite(int size) {
            super(size);
        }

        @Override
        protected int getMaxSize() {
            return BooleanQuery.getMaxClauseCount();
        }

        @Override
        protected BooleanQuery getTopLevelQuery() {
            return new BooleanQuery(true);
        }

        @Override
        protected void addClause(BooleanQuery topLevel, Term term, int docCount, float boost, TermContext states) {
            TermQuery tq = new TermQuery(term, states);
            tq.setBoost(boost);
            topLevel.add(tq, BooleanClause.Occur.SHOULD);
        }

        @Override
        void adjustScoreTerms(IndexReader reader, TopTermsRewrite.ScoreTerm[] scoreTerms) {
            if (scoreTerms.length <= 1) {
                return;
            }
            int maxDoc = reader.maxDoc();
            int maxDf = 0;
            long maxTtf = 0L;
            for (TopTermsRewrite.ScoreTerm scoreTerm : scoreTerms) {
                TermContext ctx = scoreTerm.termState;
                int df = ctx.docFreq();
                maxDf = Math.max(df, maxDf);
                long ttf = ctx.totalTermFreq();
                maxTtf = ttf == -1L || maxTtf == -1L ? -1L : Math.max(ttf, maxTtf);
            }
            assert (maxDf >= 0) : "DF must be >= 0";
            if (maxDf == 0) {
                return;
            }
            assert (maxTtf == -1L || maxTtf >= (long)maxDf);
            for (int i = 0; i < scoreTerms.length; ++i) {
                TermContext ctx = scoreTerms[i].termState;
                ctx = MultiTermQuery.adjustFrequencies(ctx, maxDf, maxTtf);
                TopTermsRewrite.ScoreTerm adjustedScoreTerm = new TopTermsRewrite.ScoreTerm(ctx);
                adjustedScoreTerm.boost = scoreTerms[i].boost;
                adjustedScoreTerm.bytes.copyBytes(scoreTerms[i].bytes);
                scoreTerms[i] = adjustedScoreTerm;
            }
        }
    }

    public static final class TopTermsBoostOnlyBooleanQueryRewrite
    extends TopTermsRewrite<BooleanQuery> {
        public TopTermsBoostOnlyBooleanQueryRewrite(int size) {
            super(size);
        }

        @Override
        protected int getMaxSize() {
            return BooleanQuery.getMaxClauseCount();
        }

        @Override
        protected BooleanQuery getTopLevelQuery() {
            return new BooleanQuery(true);
        }

        @Override
        protected void addClause(BooleanQuery topLevel, Term term, int docFreq, float boost, TermContext states) {
            ConstantScoreQuery q = new ConstantScoreQuery(new TermQuery(term, states));
            q.setBoost(boost);
            topLevel.add(q, BooleanClause.Occur.SHOULD);
        }
    }

    public static final class TopTermsScoringBooleanQueryRewrite
    extends TopTermsRewrite<BooleanQuery> {
        public TopTermsScoringBooleanQueryRewrite(int size) {
            super(size);
        }

        @Override
        protected int getMaxSize() {
            return BooleanQuery.getMaxClauseCount();
        }

        @Override
        protected BooleanQuery getTopLevelQuery() {
            return new BooleanQuery(true);
        }

        @Override
        protected void addClause(BooleanQuery topLevel, Term term, int docCount, float boost, TermContext states) {
            TermQuery tq = new TermQuery(term, states);
            tq.setBoost(boost);
            topLevel.add(tq, BooleanClause.Occur.SHOULD);
        }
    }
}

