/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core;

import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.olingo.odata2.api.ODataDebugCallback;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.uri.PathInfo;

public class ODataContextImpl
implements ODataContext {
    private static final String ODATA_BATCH_PARENT_CONTEXT = "~odataBatchParentContext";
    private static final String ODATA_REQUEST = "~odataRequest";
    private static final String DEBUG_MODE = "~debugMode";
    private static final String SERVICE = "~service";
    private static final String SERVICE_FACTORY = "~serviceFactory";
    private static final String PATH_INFO = "~pathInfo";
    private static final String RUNTIME_MEASUREMENTS = "~runtimeMeasurements";
    private static final String HTTP_METHOD = "~httpMethod";
    private Map<String, Object> parameterTable = new HashMap<String, Object>();
    private List<Locale> acceptableLanguages;

    public ODataContextImpl(ODataRequest request, ODataServiceFactory factory) {
        this.setServiceFactory(factory);
        this.setRequest(request);
        this.setPathInfo(request.getPathInfo());
        if (request.getMethod() != null) {
            this.setHttpMethod(request.getMethod().name());
        }
        this.setAcceptableLanguages(request.getAcceptableLanguages());
        this.setDebugMode(this.checkDebugMode(request.getQueryParameters()));
    }

    @Override
    public void setParameter(String name, Object value) {
        this.parameterTable.put(name, value);
    }

    @Override
    public void removeParameter(String name) {
        this.parameterTable.remove(name);
    }

    @Override
    public Object getParameter(String name) {
        return this.parameterTable.get(name);
    }

    @Override
    public boolean isInDebugMode() {
        return this.getParameter(DEBUG_MODE) != null && (Boolean)this.getParameter(DEBUG_MODE) != false;
    }

    @Override
    public void setDebugMode(boolean debugMode) {
        this.setParameter(DEBUG_MODE, debugMode);
    }

    public void setService(ODataService service) {
        this.setParameter(SERVICE, service);
    }

    @Override
    public ODataService getService() throws ODataException {
        return (ODataService)this.getParameter(SERVICE);
    }

    public void setPathInfo(PathInfo uriInfo) {
        this.setParameter(PATH_INFO, uriInfo);
    }

    @Override
    public PathInfo getPathInfo() throws ODataException {
        return (PathInfo)this.getParameter(PATH_INFO);
    }

    public void setServiceFactory(ODataServiceFactory serviceFactory) {
        this.setParameter(SERVICE_FACTORY, serviceFactory);
    }

    @Override
    public ODataServiceFactory getServiceFactory() {
        return (ODataServiceFactory)this.getParameter(SERVICE_FACTORY);
    }

    @Override
    public int startRuntimeMeasurement(String className, String methodName) {
        if (this.isInDebugMode()) {
            List<ODataContext.RuntimeMeasurement> runtimeMeasurements = this.getRuntimeMeasurements();
            int handleId = runtimeMeasurements.size();
            RuntimeMeasurementImpl measurement = new RuntimeMeasurementImpl();
            measurement.setTimeStarted(System.nanoTime());
            measurement.setClassName(className);
            measurement.setMethodName(methodName);
            measurement.setMemoryStarted(ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed());
            runtimeMeasurements.add(measurement);
            return handleId;
        }
        return 0;
    }

    @Override
    public void stopRuntimeMeasurement(int handle) {
        if (this.isInDebugMode()) {
            long stopTime = System.nanoTime();
            long stopMemory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getUsed();
            ODataContext.RuntimeMeasurement runtimeMeasurement = this.getRuntimeMeasurement(handle);
            if (runtimeMeasurement != null) {
                runtimeMeasurement.setTimeStopped(stopTime);
                runtimeMeasurement.setMemoryStopped(stopMemory);
            }
        }
    }

    private ODataContext.RuntimeMeasurement getRuntimeMeasurement(int handle) {
        List<ODataContext.RuntimeMeasurement> runtimeMeasurements = this.getRuntimeMeasurements();
        if (handle >= 0 && handle < runtimeMeasurements.size()) {
            return runtimeMeasurements.get(handle);
        }
        return null;
    }

    @Override
    public List<ODataContext.RuntimeMeasurement> getRuntimeMeasurements() {
        ArrayList runtimeMeasurements = (ArrayList)this.getParameter(RUNTIME_MEASUREMENTS);
        if (runtimeMeasurements == null) {
            runtimeMeasurements = new ArrayList();
            this.setParameter(RUNTIME_MEASUREMENTS, runtimeMeasurements);
        }
        return runtimeMeasurements;
    }

    @Override
    public String getRequestHeader(String name) {
        ODataRequest request = (ODataRequest)this.parameterTable.get(ODATA_REQUEST);
        return request.getRequestHeaderValue(name);
    }

    @Override
    public Map<String, List<String>> getRequestHeaders() {
        ODataRequest request = (ODataRequest)this.parameterTable.get(ODATA_REQUEST);
        return request.getRequestHeaders();
    }

    @Override
    public List<Locale> getAcceptableLanguages() {
        return Collections.unmodifiableList(this.acceptableLanguages);
    }

    public void setAcceptableLanguages(List<Locale> acceptableLanguages) {
        this.acceptableLanguages = acceptableLanguages;
        if (this.acceptableLanguages.isEmpty()) {
            Locale wildcard = new Locale("*");
            this.acceptableLanguages.add(wildcard);
        }
    }

    public void setHttpMethod(String httpMethod) {
        this.setParameter(HTTP_METHOD, httpMethod);
    }

    @Override
    public String getHttpMethod() {
        return (String)this.getParameter(HTTP_METHOD);
    }

    public void setRequest(ODataRequest request) {
        this.setParameter(ODATA_REQUEST, request);
    }

    private boolean checkDebugMode(Map<String, String> queryParameters) {
        ODataDebugCallback callback = (ODataDebugCallback)this.getServiceFactory().getCallback(ODataDebugCallback.class);
        return callback == null ? ODataContextImpl.getQueryDebugValue(queryParameters) != null : callback.isDebugEnabled();
    }

    private static String getQueryDebugValue(Map<String, String> queryParameters) {
        String debugValue = queryParameters.get("odata-debug");
        return "json".equals(debugValue) || "html".equals(debugValue) || "download".equals(debugValue) ? debugValue : null;
    }

    public void setBatchParentContext(ODataContext ctx) {
        this.setParameter(ODATA_BATCH_PARENT_CONTEXT, ctx);
    }

    @Override
    public ODataContext getBatchParentContext() {
        return (ODataContext)this.parameterTable.get(ODATA_BATCH_PARENT_CONTEXT);
    }

    @Override
    public boolean isInBatchMode() {
        return this.parameterTable.containsKey(ODATA_BATCH_PARENT_CONTEXT);
    }

    protected class RuntimeMeasurementImpl
    implements ODataContext.RuntimeMeasurement {
        private String className;
        private String methodName;
        private long timeStarted;
        private long timeStopped;
        private long memoryStarted;
        private long memoryStopped;

        protected RuntimeMeasurementImpl() {
        }

        @Override
        public void setClassName(String className) {
            this.className = className;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public String getMethodName() {
            return this.methodName;
        }

        @Override
        public void setTimeStarted(long start) {
            this.timeStarted = start;
        }

        @Override
        public long getTimeStarted() {
            return this.timeStarted;
        }

        @Override
        public void setTimeStopped(long stop) {
            this.timeStopped = stop;
        }

        @Override
        public long getTimeStopped() {
            return this.timeStopped;
        }

        public String toString() {
            return this.className + "." + this.methodName + ": duration: " + (this.timeStopped - this.timeStarted) + ", memory: " + (this.memoryStopped - this.memoryStarted);
        }

        @Override
        public void setMemoryStarted(long used) {
            this.memoryStarted = used;
        }

        @Override
        public void setMemoryStopped(long used) {
            this.memoryStopped = used;
        }

        @Override
        public long getMemoryStarted() {
            return this.memoryStarted;
        }

        @Override
        public long getMemoryStopped() {
            return this.memoryStopped;
        }
    }
}

