/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.io.Writer;
import java.util.List;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.edm.Edm;
import org.apache.olingo.odata2.api.edm.EdmEntitySetInfo;
import org.apache.olingo.odata2.api.edm.EdmServiceMetadata;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataException;

public class AtomServiceDocumentProducer {
    private static final String DEFAULT_CHARSET = "utf-8";
    private static final String XML_VERSION = "1.0";
    private final Edm edm;
    private final String serviceRoot;

    public AtomServiceDocumentProducer(Edm edm, String serviceRoot) {
        this.edm = edm;
        this.serviceRoot = serviceRoot;
    }

    public void writeServiceDocument(Writer writer) throws EntityProviderException {
        EdmServiceMetadata serviceMetadata = this.edm.getServiceMetadata();
        try {
            XMLStreamWriter xmlStreamWriter = XMLOutputFactory.newInstance().createXMLStreamWriter(writer);
            xmlStreamWriter.writeStartDocument(DEFAULT_CHARSET, XML_VERSION);
            xmlStreamWriter.setPrefix("xml", "http://www.w3.org/XML/1998/namespace");
            xmlStreamWriter.setPrefix("atom", "http://www.w3.org/2005/Atom");
            xmlStreamWriter.setDefaultNamespace("http://www.w3.org/2007/app");
            xmlStreamWriter.writeStartElement("service");
            xmlStreamWriter.writeAttribute("xml", "http://www.w3.org/XML/1998/namespace", "base", this.serviceRoot);
            xmlStreamWriter.writeDefaultNamespace("http://www.w3.org/2007/app");
            xmlStreamWriter.writeNamespace("atom", "http://www.w3.org/2005/Atom");
            xmlStreamWriter.writeStartElement("workspace");
            xmlStreamWriter.writeStartElement("http://www.w3.org/2005/Atom", "title");
            xmlStreamWriter.writeCharacters("Default");
            xmlStreamWriter.writeEndElement();
            List<EdmEntitySetInfo> entitySetInfos = serviceMetadata.getEntitySetInfos();
            for (EdmEntitySetInfo info : entitySetInfos) {
                xmlStreamWriter.writeStartElement("collection");
                xmlStreamWriter.writeAttribute("href", info.getEntitySetUri().toASCIIString());
                xmlStreamWriter.writeStartElement("http://www.w3.org/2005/Atom", "title");
                xmlStreamWriter.writeCharacters(info.getEntitySetName());
                xmlStreamWriter.writeEndElement();
                xmlStreamWriter.writeEndElement();
            }
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndElement();
            xmlStreamWriter.writeEndDocument();
            xmlStreamWriter.flush();
        }
        catch (FactoryConfigurationError e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
        catch (ODataException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }
}

