/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.callback.TombstoneCallback;
import org.apache.olingo.odata2.api.ep.callback.TombstoneCallbackResult;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.producer.JsonDeletedEntryEntityProducer;
import org.apache.olingo.odata2.core.ep.producer.JsonEntryEntityProducer;
import org.apache.olingo.odata2.core.ep.util.JsonStreamWriter;

public class JsonFeedEntityProducer {
    private final EntityProviderWriteProperties properties;

    public JsonFeedEntityProducer(EntityProviderWriteProperties properties) throws EntityProviderException {
        this.properties = properties == null ? EntityProviderWriteProperties.serviceRoot(null).build() : properties;
    }

    public void append(Writer writer, EntityInfoAggregator entityInfo, List<Map<String, Object>> data, boolean isRootElement) throws EntityProviderException {
        JsonStreamWriter jsonStreamWriter = new JsonStreamWriter(writer);
        TombstoneCallback callback = this.getTombstoneCallback();
        try {
            jsonStreamWriter.beginObject();
            if (isRootElement) {
                jsonStreamWriter.name("d").beginObject();
            }
            if (this.properties.getInlineCountType() == InlineCount.ALLPAGES) {
                int inlineCount = this.properties.getInlineCount() == null ? 0 : this.properties.getInlineCount();
                jsonStreamWriter.namedStringValueRaw("__count", String.valueOf(inlineCount)).separator();
            }
            jsonStreamWriter.name("results").beginArray();
            JsonEntryEntityProducer entryProducer = new JsonEntryEntityProducer(this.properties);
            boolean first = true;
            for (Map<String, Object> entryData : data) {
                if (first) {
                    first = false;
                } else {
                    jsonStreamWriter.separator();
                }
                entryProducer.append(writer, entityInfo, entryData, false);
            }
            if (callback != null) {
                JsonDeletedEntryEntityProducer deletedEntryProducer = new JsonDeletedEntryEntityProducer(this.properties);
                TombstoneCallbackResult callbackResult = callback.getTombstoneCallbackResult();
                List<Map<String, Object>> deletedEntries = callbackResult.getDeletedEntriesData();
                if (deletedEntries != null) {
                    deletedEntryProducer.append(writer, entityInfo, deletedEntries);
                }
            }
            jsonStreamWriter.endArray();
            this.appendNextLink(jsonStreamWriter);
            this.appendDeltaLink(callback, jsonStreamWriter);
            if (isRootElement) {
                jsonStreamWriter.endObject();
            }
            jsonStreamWriter.endObject();
        }
        catch (IOException e) {
            throw new EntityProviderException(EntityProviderException.EXCEPTION_OCCURRED.addContent(e.getClass().getSimpleName()), (Throwable)e);
        }
    }

    private TombstoneCallback getTombstoneCallback() {
        if (this.properties.getCallbacks() != null && this.properties.getCallbacks().containsKey("~tombstoneCallback")) {
            TombstoneCallback callback = (TombstoneCallback)this.properties.getCallbacks().get("~tombstoneCallback");
            return callback;
        }
        return null;
    }

    private void appendNextLink(JsonStreamWriter jsonStreamWriter) throws IOException {
        if (this.properties.getNextLink() != null) {
            jsonStreamWriter.separator().namedStringValue("__next", this.properties.getNextLink());
        }
    }

    private void appendDeltaLink(TombstoneCallback callback, JsonStreamWriter jsonStreamWriter) throws IOException {
        TombstoneCallbackResult callbackResult;
        String deltaLink;
        if (callback != null && (deltaLink = (callbackResult = callback.getTombstoneCallbackResult()).getDeltaLink()) != null) {
            jsonStreamWriter.separator().namedStringValue("__delta", deltaLink);
        }
    }
}

