/*
 * Decompiled with CFR 0.152.
 */
package org.apache.olingo.odata2.core.ep.producer;

import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.core.ep.aggregator.EntityInfoAggregator;
import org.apache.olingo.odata2.core.ep.producer.AtomEntryEntityProducer;

public class XmlLinkEntityProducer {
    private final EntityProviderWriteProperties properties;

    public XmlLinkEntityProducer(EntityProviderWriteProperties properties) throws EntityProviderException {
        this.properties = properties == null ? EntityProviderWriteProperties.serviceRoot(null).build() : properties;
    }

    public void append(XMLStreamWriter writer, EntityInfoAggregator entityInfo, Map<String, Object> data, boolean isRootElement) throws EntityProviderException {
        try {
            writer.writeStartElement("uri");
            if (isRootElement) {
                writer.writeDefaultNamespace("http://schemas.microsoft.com/ado/2007/08/dataservices");
            }
            if (this.properties.getServiceRoot() != null) {
                writer.writeCharacters(this.properties.getServiceRoot().toASCIIString());
            }
            writer.writeCharacters(AtomEntryEntityProducer.createSelfLink(entityInfo, data, null));
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException e) {
            throw new EntityProviderException(EntityProviderException.COMMON, (Throwable)e);
        }
    }
}

