package org.apache.solr.analysis;


/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

import org.apache.lucene.analysis.CharStream;

/**
* Factory for {@link HTMLStripCharFilter}. 
 * <pre class="prettyprint" >
 * &lt;fieldType name="text_html" class="solr.TextField" positionIncrementGap="100"&gt;
 *   &lt;analyzer&gt;
 *     &lt;charFilter class="solr.HTMLStripCharFilterFactory"/&gt;
 *     &lt;tokenizer class="solr.WhitespaceTokenizerFactory"/&gt;
 *   &lt;/analyzer&gt;
 * &lt;/fieldType&gt;</pre
 * @version $Id: HTMLStripCharFilterFactory.java 1073344 2011-02-22 14:35:02Z koji $  
 */
 public class HTMLStripCharFilterFactory extends BaseCharFilterFactory {

  public HTMLStripCharFilter create(CharStream input) {
    return new HTMLStripCharFilter(input);
  }

}
