/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analysis;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.solr.analysis.CapitalizationFilterFactory;

final class CapitalizationFilter
extends TokenFilter {
    private final CapitalizationFilterFactory factory;
    private final CharTermAttribute termAtt = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);

    public CapitalizationFilter(TokenStream in, CapitalizationFilterFactory factory) {
        super(in);
        this.factory = factory;
    }

    public boolean incrementToken() throws IOException {
        if (!this.input.incrementToken()) {
            return false;
        }
        char[] termBuffer = this.termAtt.buffer();
        int termBufferLength = this.termAtt.length();
        char[] backup = null;
        if (this.factory.maxWordCount < Integer.MAX_VALUE) {
            backup = new char[termBufferLength];
            System.arraycopy(termBuffer, 0, backup, 0, termBufferLength);
        }
        if (termBufferLength < this.factory.maxTokenLength) {
            int wordCount = 0;
            int lastWordStart = 0;
            for (int i = 0; i < termBufferLength; ++i) {
                int len;
                char c = termBuffer[i];
                if (c > ' ' && c != '.' || (len = i - lastWordStart) <= 0) continue;
                this.factory.processWord(termBuffer, lastWordStart, len, wordCount++);
                lastWordStart = i + 1;
                ++i;
            }
            if (lastWordStart < termBufferLength) {
                this.factory.processWord(termBuffer, lastWordStart, termBufferLength - lastWordStart, wordCount++);
            }
            if (wordCount > this.factory.maxWordCount) {
                this.termAtt.copyBuffer(backup, 0, termBufferLength);
            }
        }
        return true;
    }
}

