/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GraphPinScene<N, E, P>
extends ObjectScene {
    private HashSet<N> nodes = new HashSet();
    private Set<N> nodesUm = Collections.unmodifiableSet(this.nodes);
    private HashSet<E> edges = new HashSet();
    private Set<E> edgesUm = Collections.unmodifiableSet(this.edges);
    private HashSet<P> pins = new HashSet();
    private Set<P> pinsUm = Collections.unmodifiableSet(this.pins);
    private HashMap<N, HashSet<P>> nodePins = new HashMap();
    private HashMap<P, N> pinNodes = new HashMap();
    private HashMap<E, P> edgeSourcePins = new HashMap();
    private HashMap<E, P> edgeTargetPins = new HashMap();
    private HashMap<P, List<E>> pinInputEdges = new HashMap();
    private HashMap<P, List<E>> pinOutputEdges = new HashMap();

    public final Widget addNode(N node) {
        assert (node != null) : "Null parameter";
        assert (!this.nodes.contains(node)) : "Node (" + node + ") already added";
        Widget widget = this.attachNodeWidget(node);
        this.nodes.add(node);
        this.nodePins.put(node, new HashSet());
        this.addObject(node, widget);
        this.notifyNodeAdded(node, widget);
        return widget;
    }

    public final void removeNode(N node) {
        assert (node != null && this.nodes.contains(node));
        for (Object pin : new HashSet(this.nodePins.get(node))) {
            this.removePin(pin);
        }
        this.nodes.remove(node);
        this.nodePins.remove(node);
        Widget widget = this.findWidget(node);
        this.detachNodeWidget(node, widget);
        this.removeObject(node);
    }

    public final void removeNodeWithEdges(N node) {
        assert (node != null && this.nodes.contains(node));
        for (P pin : this.nodePins.get(node)) {
            for (E edge : this.findPinEdges(pin, true, true)) {
                if (!this.isEdge(edge)) continue;
                this.removeEdge(edge);
            }
        }
        this.removeNode(node);
    }

    public final Collection<N> getNodes() {
        return this.nodesUm;
    }

    public final Widget addEdge(E edge) {
        assert (edge != null && !this.edges.contains(edge));
        Widget widget = this.attachEdgeWidget(edge);
        this.edges.add(edge);
        this.addObject(edge, widget);
        this.notifyEdgeAdded(edge, widget);
        return widget;
    }

    public final void removeEdge(E edge) {
        assert (edge != null && this.edges.contains(edge));
        this.setEdgeSource(edge, null);
        this.setEdgeTarget(edge, null);
        this.edges.remove(edge);
        this.edgeSourcePins.remove(edge);
        this.edgeTargetPins.remove(edge);
        Widget widget = this.findWidget(edge);
        this.detachEdgeWidget(edge, widget);
        this.removeObject(edge);
    }

    public final Collection<E> getEdges() {
        return this.edgesUm;
    }

    public final Widget addPin(N node, P pin) {
        assert (node != null && pin != null && !this.pins.contains(pin));
        Widget widget = this.attachPinWidget(node, pin);
        this.pins.add(pin);
        this.nodePins.get(node).add(pin);
        this.pinNodes.put(pin, node);
        this.pinInputEdges.put(pin, new ArrayList());
        this.pinOutputEdges.put(pin, new ArrayList());
        this.addObject(pin, widget);
        this.notifyPinAdded(node, pin, widget);
        return widget;
    }

    public final void removePin(P pin) {
        assert (pin != null && this.pins.contains(pin));
        for (E edge : this.findPinEdges(pin, true, false)) {
            this.setEdgeSource(edge, null);
        }
        for (E edge : this.findPinEdges(pin, false, true)) {
            this.setEdgeTarget(edge, null);
        }
        this.pins.remove(pin);
        N node = this.pinNodes.remove(pin);
        this.nodePins.get(node).remove(pin);
        this.pinInputEdges.remove(pin);
        this.pinOutputEdges.remove(pin);
        Widget widget = this.findWidget(pin);
        this.detachPinWidget(pin, widget);
        this.removeObject(pin);
    }

    public final void removePinWithEdges(P pin) {
        assert (pin != null && this.pins.contains(pin));
        for (E edge : this.findPinEdges(pin, true, true)) {
            if (!this.isEdge(edge)) continue;
            this.removeEdge(edge);
        }
        this.removePin(pin);
    }

    public final N getPinNode(P pin) {
        return this.pinNodes.get(pin);
    }

    public final Collection<P> getPins() {
        return this.pinsUm;
    }

    public final Collection<P> getNodePins(N node) {
        if (node == null) {
            return null;
        }
        HashSet<P> ps = this.nodePins.get(node);
        if (ps == null) {
            return null;
        }
        return Collections.unmodifiableCollection(ps);
    }

    public final void setEdgeSource(E edge, P sourcePin) {
        assert (edge != null && this.edges.contains(edge));
        if (sourcePin != null) assert (this.pins.contains(sourcePin));
        P oldPin = this.edgeSourcePins.put(edge, sourcePin);
        if (GeomUtil.equals(oldPin, sourcePin)) {
            return;
        }
        if (oldPin != null) {
            this.pinOutputEdges.get(oldPin).remove(edge);
        }
        if (sourcePin != null) {
            this.pinOutputEdges.get(sourcePin).add(edge);
        }
        this.attachEdgeSourceAnchor(edge, oldPin, sourcePin);
    }

    public final void setEdgeTarget(E edge, P targetPin) {
        assert (edge != null && this.edges.contains(edge));
        if (targetPin != null) assert (this.pins.contains(targetPin));
        P oldPin = this.edgeTargetPins.put(edge, targetPin);
        if (GeomUtil.equals(oldPin, targetPin)) {
            return;
        }
        if (oldPin != null) {
            this.pinInputEdges.get(oldPin).remove(edge);
        }
        if (targetPin != null) {
            this.pinInputEdges.get(targetPin).add(edge);
        }
        this.attachEdgeTargetAnchor(edge, oldPin, targetPin);
    }

    public final P getEdgeSource(E edge) {
        return this.edgeSourcePins.get(edge);
    }

    public final P getEdgeTarget(E edge) {
        return this.edgeTargetPins.get(edge);
    }

    public final Collection<E> findPinEdges(P pin, boolean allowOutputEdges, boolean allowInputEdges) {
        assert (this.isPin(pin)) : "Pin " + pin + " is not in the scene";
        ArrayList list = new ArrayList();
        if (allowInputEdges) {
            list.addAll(this.pinInputEdges.get(pin));
        }
        if (allowOutputEdges) {
            list.addAll(this.pinOutputEdges.get(pin));
        }
        return list;
    }

    public final Collection<E> findEdgesBetween(P sourcePin, P targetPin) {
        assert (this.isPin(sourcePin)) : "Source pin " + sourcePin + " is not in the scene";
        assert (this.isPin(targetPin)) : "Target pin " + targetPin + " is not in the scene";
        HashSet<E> list = new HashSet<E>();
        List<E> inputEdges = this.pinInputEdges.get(targetPin);
        List<E> outputEdges = this.pinOutputEdges.get(sourcePin);
        for (E edge : inputEdges) {
            if (!outputEdges.contains(edge)) continue;
            list.add(edge);
        }
        return list;
    }

    public boolean isNode(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.nodes.contains(object);
    }

    public boolean isEdge(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.edges.contains(object);
    }

    public boolean isPin(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.pins.contains(object);
    }

    protected void notifyNodeAdded(N node, Widget widget) {
    }

    protected void notifyEdgeAdded(E edge, Widget widget) {
    }

    protected void notifyPinAdded(N node, P pin, Widget widget) {
    }

    protected void detachNodeWidget(N node, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected void detachEdgeWidget(E edge, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected void detachPinWidget(P pin, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected abstract Widget attachNodeWidget(N var1);

    protected abstract Widget attachEdgeWidget(E var1);

    protected abstract Widget attachPinWidget(N var1, P var2);

    protected abstract void attachEdgeSourceAnchor(E var1, P var2, P var3);

    protected abstract void attachEdgeTargetAnchor(E var1, P var2, P var3);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class StringGraph
    extends GraphPinScene<String, String, String> {
    }
}

