/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.lookup;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import org.openide.util.Lookup;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.ArrayStorage;
import org.openide.util.lookup.InheritanceTree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DelegatingStorage<Transaction>
implements Serializable,
AbstractLookup.Storage<Transaction> {
    private AbstractLookup.Storage<Transaction> delegate;
    private Thread owner;

    public DelegatingStorage(AbstractLookup.Storage<Transaction> d) {
        this.delegate = d;
        this.owner = Thread.currentThread();
    }

    public Object writeReplace() {
        return this.delegate;
    }

    public void checkForTreeModification() {
        if (Thread.currentThread() == this.owner) {
            throw new AbstractLookup.ISE("You are trying to modify lookup from lookup query!");
        }
    }

    public static boolean isSimple(AbstractLookup.Storage s) {
        if (s instanceof DelegatingStorage) {
            return ((DelegatingStorage)s).delegate instanceof ArrayStorage;
        }
        return s instanceof ArrayStorage;
    }

    public AbstractLookup.Storage<Transaction> exitDelegate() {
        if (Thread.currentThread() != this.owner) {
            throw new IllegalStateException("Onwer: " + this.owner + " caller: " + Thread.currentThread());
        }
        AbstractLookup.Storage<Transaction> d = this.delegate;
        this.delegate = null;
        return d;
    }

    @Override
    public boolean add(AbstractLookup.Pair<?> item, Transaction transaction) {
        return this.delegate.add(item, transaction);
    }

    @Override
    public void remove(AbstractLookup.Pair item, Transaction transaction) {
        this.delegate.remove(item, transaction);
    }

    @Override
    public void retainAll(Map retain, Transaction transaction) {
        this.delegate.retainAll(retain, transaction);
    }

    private void changeDelegate(InheritanceTree st) {
        this.delegate = st;
    }

    @Override
    public Transaction beginTransaction(int ensure) {
        try {
            return this.delegate.beginTransaction(ensure);
        }
        catch (UnsupportedOperationException ex) {
            ArrayStorage arr = (ArrayStorage)this.delegate;
            InheritanceTree inh = new InheritanceTree();
            this.changeDelegate(inh);
            Enumeration<AbstractLookup.Pair<Object>> en = arr.lookup(Object.class);
            while (en.hasMoreElements()) {
                if (inh.add(en.nextElement(), new ArrayList<Class>())) continue;
                throw new IllegalStateException("All objects have to be accepted");
            }
            AbstractLookup.ReferenceToResult ref = arr.cleanUpResult(null);
            if (ref != null) {
                ref.cloneList(inh);
            }
            return this.delegate.beginTransaction(ensure);
        }
    }

    @Override
    public AbstractLookup.ReferenceToResult cleanUpResult(Lookup.Template templ) {
        return this.delegate.cleanUpResult(templ);
    }

    @Override
    public void endTransaction(Transaction transaction, Set<AbstractLookup.R> modified) {
        this.delegate.endTransaction(transaction, modified);
    }

    @Override
    public <T> Enumeration<AbstractLookup.Pair<T>> lookup(Class<T> clazz) {
        return this.delegate.lookup(clazz);
    }

    @Override
    public AbstractLookup.ReferenceToResult registerReferenceToResult(AbstractLookup.ReferenceToResult newRef) {
        return this.delegate.registerReferenceToResult(newRef);
    }
}

