/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.CharacterRule;
import org.passay.PasswordData;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public abstract class AbstractCharacterRule
implements CharacterRule {
    protected int numCharacters = 1;

    @Override
    public void setNumberOfCharacters(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("argument must be greater than zero");
        }
        this.numCharacters = n;
    }

    @Override
    public int getNumberOfCharacters() {
        return this.numCharacters;
    }

    protected abstract String getCharacterTypes(String var1);

    protected abstract String getErrorCode();

    @Override
    public RuleResult validate(PasswordData passwordData) {
        String matchingChars = this.getCharacterTypes(passwordData.getPassword());
        if (matchingChars.length() >= this.numCharacters) {
            return new RuleResult(true);
        }
        return new RuleResult(false, new RuleResultDetail(this.getErrorCode(), this.createRuleResultDetailParameters(passwordData.getPassword(), matchingChars)));
    }

    protected Map<String, Object> createRuleResultDetailParameters(String password, String matchingChars) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("minimumRequired", this.numCharacters);
        m.put("matchingCharacterCount", matchingChars.length());
        m.put("validCharacters", this.getValidCharacters());
        m.put("matchingCharacters", matchingChars);
        return m;
    }

    public String toString() {
        return String.format("%s@%h::numberOfCharacters=%s", this.getClass().getName(), this.hashCode(), this.numCharacters);
    }
}

