/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;
import java.util.LinkedHashMap;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public abstract class AbstractSequenceRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_SEQUENCE";
    public static final int DEFAULT_SEQUENCE_LENGTH = 5;
    public static final int MINIMUM_SEQUENCE_LENGTH = 3;
    protected int sequenceLength = 5;
    protected boolean wrapSequence;
    protected boolean reportAllFailures = true;

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        String password = passwordData.getPassword();
        int max = password.length() - this.sequenceLength + 1;
        for (int i = 0; i < this.getSequenceCount(); ++i) {
            for (int j = 0; j < max; ++j) {
                char c;
                Sequence sequence = this.newSequence(this.getSequence(i), password.charAt(j));
                if (sequence == null) continue;
                int position = j;
                while (sequence.forward() && ((c = password.charAt(++position)) == sequence.currentLower() || c == sequence.currentUpper())) {
                    sequence.addMatchCharacter(c);
                }
                if (sequence.matchCount() == this.sequenceLength) {
                    this.recordFailure(result, sequence.matchString());
                }
                sequence.reset();
                position = j;
                while (sequence.backward() && ((c = password.charAt(++position)) == sequence.currentLower() || c == sequence.currentUpper())) {
                    sequence.addMatchCharacter(c);
                }
                if (sequence.matchCount() != this.sequenceLength) continue;
                this.recordFailure(result, sequence.matchString());
            }
        }
        return result;
    }

    public String toString() {
        return String.format("%s@%h::length=%d,wrap=%s", this.getClass().getName(), this.hashCode(), this.sequenceLength, this.wrapSequence);
    }

    protected void setSequenceLength(int sl) {
        if (sl < 3) {
            throw new IllegalArgumentException(String.format("sequence length must be >= %s", 3));
        }
        this.sequenceLength = sl;
    }

    protected abstract char[][] getSequence(int var1);

    protected abstract int getSequenceCount();

    private Sequence newSequence(char[][] chars, char first) {
        for (int i = 0; i < chars.length; ++i) {
            if (first != chars[i][0] && first != chars[i][1]) continue;
            Sequence s = new Sequence(chars, i, this.sequenceLength, this.wrapSequence);
            s.addMatchCharacter(first);
            return s;
        }
        return null;
    }

    private void recordFailure(RuleResult result, String match) {
        if (this.reportAllFailures || result.getDetails().size() == 0) {
            LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
            m.put("sequence", match);
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, m));
        }
    }

    private class Sequence {
        private final char[][] chars;
        private final int start;
        private final int length;
        private int ubound;
        private int lbound;
        private int position;
        private final StringBuilder matches;

        public Sequence(char[][] characters, int startIndex, int count, boolean wrap) {
            this.chars = characters;
            this.start = startIndex;
            this.length = count;
            this.lbound = this.start - this.length;
            this.ubound = this.start + this.length;
            if (this.lbound < -1 && !wrap) {
                this.lbound = -1;
            }
            if (this.ubound >= characters.length && !wrap) {
                this.ubound = characters.length;
            }
            this.position = this.start;
            this.matches = new StringBuilder(this.length);
        }

        public boolean forward() {
            return ++this.position < this.ubound;
        }

        public boolean backward() {
            return --this.position > this.lbound;
        }

        public void reset() {
            this.position = this.start;
            this.matches.delete(1, this.length);
        }

        public char currentLower() {
            int i = this.position < 0 ? this.chars.length + this.position : (this.position >= this.chars.length ? this.position - this.chars.length : this.position);
            return this.chars[i][0];
        }

        public char currentUpper() {
            int i = this.position < 0 ? this.chars.length + this.position : (this.position >= this.chars.length ? this.position - this.chars.length : this.position);
            return this.chars[i][1];
        }

        public void addMatchCharacter(char c) {
            this.matches.append(c);
        }

        public int matchCount() {
            return this.matches.length();
        }

        public String matchString() {
            return this.matches.toString();
        }

        public String toString() {
            StringBuilder charsString = new StringBuilder();
            for (int i = 0; i < this.chars.length; ++i) {
                charsString.append("[").append(i).append(Arrays.toString(this.chars[i])).append("]");
            }
            return String.format("%s@%h::chars=%s,start=%s,length=%s,ubound=%s,lbound=%s,position=%s,matches=%s", this.getClass().getName(), this.hashCode(), charsString, this.start, this.length, this.ubound, this.lbound, this.position, this.matches);
        }
    }
}

