/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class AllowedCharacterRule
implements Rule {
    public static final String ERROR_CODE = "ALLOWED_CHAR";
    private final char[] allowedChar;

    public AllowedCharacterRule(char[] c) {
        this.allowedChar = c;
        Arrays.sort(this.allowedChar);
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        for (char c : passwordData.getPassword().toCharArray()) {
            if (Arrays.binarySearch(this.allowedChar, c) >= 0) continue;
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(c)));
            break;
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(char c) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("illegalCharacter", Character.valueOf(c));
        return m;
    }

    public String toString() {
        return String.format("%s@%h::allowedChar=%s", this.getClass().getName(), this.hashCode(), this.allowedChar != null ? Arrays.toString(this.allowedChar) : null);
    }
}

