/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class AllowedRegexRule
implements Rule {
    public static final String ERROR_CODE = "ALLOWED_MATCH";
    protected final Pattern pattern;

    public AllowedRegexRule(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        Matcher m = this.pattern.matcher(passwordData.getPassword());
        if (!m.find()) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters()));
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters() {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("pattern", this.pattern);
        return m;
    }

    public String toString() {
        return String.format("%s@%h::pattern=%s", this.getClass().getName(), this.hashCode(), this.pattern);
    }
}

