/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.passay.CharacterRule;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class CharacterCharacteristicsRule
implements Rule {
    public static final String ERROR_CODE = "INSUFFICIENT_CHARACTERISTICS";
    private List<CharacterRule> rules = new ArrayList<CharacterRule>();
    private int numCharacteristics = 1;
    private boolean reportRuleFailures = true;

    public List<CharacterRule> getRules() {
        return this.rules;
    }

    public void setRules(List<CharacterRule> l) {
        this.rules = l;
    }

    public void setNumberOfCharacteristics(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("argument must be greater than zero");
        }
        this.numCharacteristics = n;
    }

    public int getNumberOfCharacteristics() {
        return this.numCharacteristics;
    }

    public boolean getReportRuleFailures() {
        return this.reportRuleFailures;
    }

    public void setReportRuleFailures(boolean b) {
        this.reportRuleFailures = b;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        if (this.numCharacteristics > this.rules.size()) {
            throw new IllegalStateException("Number of characteristics must be <= to the number of rules");
        }
        int successCount = 0;
        RuleResult result = new RuleResult(true);
        for (CharacterRule rule : this.rules) {
            RuleResult rr = rule.validate(passwordData);
            if (!rr.isValid()) {
                if (!this.reportRuleFailures) continue;
                result.getDetails().addAll(rr.getDetails());
                continue;
            }
            ++successCount;
        }
        if (successCount < this.numCharacteristics) {
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(successCount)));
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(int success) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("successCount", success);
        m.put("minimumRequired", this.numCharacteristics);
        m.put("ruleCount", this.rules.size());
        return m;
    }

    public String toString() {
        return String.format("%s@%h::numberOfCharacteristics=%s,rules=%s", this.getClass().getName(), this.hashCode(), this.numCharacteristics, this.rules);
    }
}

