/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import org.passay.AbstractCharacterRule;
import org.passay.PasswordUtils;

public class DigitCharacterRule
extends AbstractCharacterRule {
    public static final String CHARS = "0123456789";
    public static final String ERROR_CODE = "INSUFFICIENT_DIGIT";

    public DigitCharacterRule() {
    }

    public DigitCharacterRule(int num) {
        this.setNumberOfCharacters(num);
    }

    @Override
    public String getValidCharacters() {
        return CHARS;
    }

    @Override
    protected String getErrorCode() {
        return ERROR_CODE;
    }

    @Override
    protected String getCharacterTypes(String password) {
        return PasswordUtils.getMatchingCharacters(CHARS, password);
    }
}

