/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class HistoryRule
implements Rule {
    public static final String ERROR_CODE = "HISTORY_VIOLATION";

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        List<PasswordData.HistoricalReference> references = passwordData.getPasswordReferences(PasswordData.HistoricalReference.class);
        int size = references.size();
        if (size == 0) {
            return result;
        }
        String cleartext = passwordData.getPassword();
        for (PasswordData.HistoricalReference reference : references) {
            if (!this.matches(cleartext, reference)) continue;
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(size)));
        }
        return result;
    }

    protected boolean matches(String password, PasswordData.Reference reference) {
        return password.equals(reference.getPassword());
    }

    protected Map<String, Object> createRuleResultDetailParameters(int size) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("historySize", size);
        return m;
    }
}

