/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.passay.PasswordData;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class IllegalCharacterRule
implements Rule {
    public static final String ERROR_CODE = "ILLEGAL_CHAR";
    private final char[] illegalChar;

    public IllegalCharacterRule(char[] c) {
        this.illegalChar = c;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        for (char c : this.illegalChar) {
            if (passwordData.getPassword().indexOf(c) == -1) continue;
            result.setValid(false);
            result.getDetails().add(new RuleResultDetail(ERROR_CODE, this.createRuleResultDetailParameters(c)));
            break;
        }
        return result;
    }

    protected Map<String, Object> createRuleResultDetailParameters(char c) {
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        m.put("illegalCharacter", Character.valueOf(c));
        return m;
    }

    public String toString() {
        return String.format("%s@%h::illegalChar=%s", this.getClass().getName(), this.hashCode(), this.illegalChar != null ? Arrays.toString(this.illegalChar) : null);
    }
}

