/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.passay.AlphabeticalCharacterRule;
import org.passay.AlphabeticalSequenceRule;
import org.passay.CharacterCharacteristicsRule;
import org.passay.DictionarySubstringRule;
import org.passay.DigitCharacterRule;
import org.passay.LengthRule;
import org.passay.LowercaseCharacterRule;
import org.passay.NumericalSequenceRule;
import org.passay.PasswordData;
import org.passay.PasswordValidator;
import org.passay.QwertySequenceRule;
import org.passay.RepeatCharacterRegexRule;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.SpecialCharacterRule;
import org.passay.UppercaseCharacterRule;
import org.passay.UsernameRule;
import org.passay.dictionary.FileWordList;
import org.passay.dictionary.TernaryTreeDictionary;

public final class PasswordCli {
    private PasswordCli() {
    }

    public static void main(String[] args) throws Exception {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        String username = null;
        String password = null;
        try {
            RuleResult result;
            if (args.length < 2) {
                throw new ArrayIndexOutOfBoundsException();
            }
            for (int i = 0; i < args.length; ++i) {
                if ("-l".equals(args[i])) {
                    int min = Integer.parseInt(args[++i]);
                    int max = Integer.parseInt(args[++i]);
                    LengthRule rule = new LengthRule(min, max);
                    rules.add(rule);
                    continue;
                }
                if ("-c".equals(args[i])) {
                    CharacterCharacteristicsRule rule = new CharacterCharacteristicsRule();
                    rule.getRules().add(new DigitCharacterRule(Integer.parseInt(args[++i])));
                    rule.getRules().add(new AlphabeticalCharacterRule(Integer.parseInt(args[++i])));
                    rule.getRules().add(new SpecialCharacterRule(Integer.parseInt(args[++i])));
                    rule.getRules().add(new UppercaseCharacterRule(Integer.parseInt(args[++i])));
                    rule.getRules().add(new LowercaseCharacterRule(Integer.parseInt(args[++i])));
                    rule.setNumberOfCharacteristics(Integer.parseInt(args[++i]));
                    rules.add(rule);
                    continue;
                }
                if ("-d".equals(args[i])) {
                    TernaryTreeDictionary dict = new TernaryTreeDictionary(new FileWordList(new RandomAccessFile(args[++i], "r"), false));
                    DictionarySubstringRule rule = new DictionarySubstringRule(dict);
                    rule.setMatchBackwards(true);
                    rules.add(rule);
                    continue;
                }
                if ("-u".equals(args[i])) {
                    rules.add(new UsernameRule(true, true));
                    username = args[++i];
                    continue;
                }
                if ("-s".equals(args[i])) {
                    rules.add(new QwertySequenceRule());
                    rules.add(new AlphabeticalSequenceRule());
                    rules.add(new NumericalSequenceRule());
                    rules.add(new RepeatCharacterRegexRule());
                    continue;
                }
                if ("-h".equals(args[i])) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                password = args[i];
            }
            if (password == null) {
                throw new ArrayIndexOutOfBoundsException();
            }
            PasswordData pd = new PasswordData(password);
            PasswordValidator validator = new PasswordValidator(rules);
            if (username != null) {
                pd.setUsername(username);
            }
            if ((result = validator.validate(pd)).isValid()) {
                System.out.println("Valid password");
            } else {
                for (String s : validator.getMessages(result)) {
                    System.out.println(s);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("Usage: java " + PasswordCli.class.getName() + " <options> <password> \\");
            System.out.println("");
            System.out.println("where <options> includes:");
            System.out.println("       -l (Set the min & max password length) \\");
            System.out.println("          <min> \\");
            System.out.println("          <max> \\");
            System.out.println("       -c (Set the characters which must be present in the password) \\");
            System.out.println("          (Each of the following must be >= 0) \\");
            System.out.println("          <digits> \\");
            System.out.println("          <alphabetical> \\");
            System.out.println("          <non-alphanumeric> \\");
            System.out.println("          <uppercase> \\");
            System.out.println("          <lowercase> \\");
            System.out.println("          <num> (Number of these rules to enforce) \\");
            System.out.println("       -d (Test password against a dictionary) \\");
            System.out.println("          <file> (dictionary files) \\");
            System.out.println("          <num> (number of characters in matching words) \\");
            System.out.println("       -u (Test for a user id) \\");
            System.out.println("          <userid> \\");
            System.out.println("       -s (Test for sequences) \\");
            System.out.println("       -h (Print this message) \\");
            System.exit(1);
        }
    }
}

