/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class PasswordData {
    private String password;
    private String username;
    private List<Reference> passwordReferences = new ArrayList<Reference>();

    public PasswordData() {
    }

    public PasswordData(String p) {
        this.setPassword(p);
    }

    public void setPassword(String p) {
        if (p == null) {
            throw new NullPointerException("Password cannot be null");
        }
        this.password = p;
    }

    public String getPassword() {
        return this.password;
    }

    public void setUsername(String s) {
        if (s == null) {
            throw new NullPointerException("Username cannot be null");
        }
        this.username = s;
    }

    public String getUsername() {
        return this.username;
    }

    public List<Reference> getPasswordReferences() {
        return this.passwordReferences;
    }

    public <T extends Reference> List<T> getPasswordReferences(Class<T> type) {
        ArrayList<Reference> l = new ArrayList<Reference>();
        if (this.passwordReferences != null) {
            for (Reference r : this.passwordReferences) {
                if (!type.isInstance(r)) continue;
                l.add(r);
            }
        }
        return Collections.unmodifiableList(l);
    }

    public void setPasswordReferences(List<Reference> l) {
        this.passwordReferences = l;
    }

    public static PasswordData newInstance(String p, String u, List<Reference> r) {
        PasswordData pd = new PasswordData();
        if (p != null) {
            pd.setPassword(p);
        }
        if (u != null) {
            pd.setUsername(u);
        }
        if (r != null) {
            pd.setPasswordReferences(r);
        }
        return pd;
    }

    public String toString() {
        return String.format("%s@%h::username=%s,password=%s,passwordReferences=%s", this.getClass().getName(), this.hashCode(), this.username, this.password, this.passwordReferences);
    }

    public static abstract class AbstractReference
    implements Reference {
        private final String label;
        private final String password;

        public AbstractReference(String lbl, String pass) {
            this.label = lbl;
            this.password = pass;
        }

        public String getLabel() {
            return this.label;
        }

        @Override
        public String getPassword() {
            return this.password;
        }

        public String toString() {
            return String.format("%s@%h::label=%s,password=%s", this.getClass().getName(), this.hashCode(), this.label, this.password);
        }
    }

    public static class SourceReference
    extends AbstractReference {
        public SourceReference(String pass) {
            super(null, pass);
        }

        public SourceReference(String lbl, String pass) {
            super(lbl, pass);
        }
    }

    public static class HistoricalReference
    extends AbstractReference {
        public HistoricalReference(String pass) {
            super(null, pass);
        }

        public HistoricalReference(String lbl, String pass) {
            super(lbl, pass);
        }
    }

    public static interface Reference {
        public String getPassword();
    }
}

