/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.ArrayList;
import java.util.List;
import org.passay.MessageResolver;
import org.passay.PasswordData;
import org.passay.PropertiesMessageResolver;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class PasswordValidator
implements Rule {
    private final List<Rule> passwordRules;
    private final MessageResolver messageResolver;

    public PasswordValidator(List<Rule> rules) {
        this(new PropertiesMessageResolver(), rules);
    }

    public PasswordValidator(MessageResolver resolver, List<Rule> rules) {
        this.messageResolver = resolver;
        this.passwordRules = rules;
    }

    @Override
    public RuleResult validate(PasswordData passwordData) {
        RuleResult result = new RuleResult(true);
        for (Rule rule : this.passwordRules) {
            RuleResult rr = rule.validate(passwordData);
            if (rr.isValid()) continue;
            result.setValid(false);
            result.getDetails().addAll(rr.getDetails());
        }
        return result;
    }

    public List<String> getMessages(RuleResult result) {
        ArrayList<String> messages = new ArrayList<String>();
        for (RuleResultDetail detail : result.getDetails()) {
            messages.add(this.messageResolver.resolve(detail));
        }
        return messages;
    }

    public String toString() {
        return String.format("%s@%h::passwordRules=%s,messageResolver=%s", this.getClass().getName(), this.hashCode(), this.passwordRules, this.messageResolver);
    }
}

