/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.nio.charset.StandardCharsets;
import org.passay.PasswordData;
import org.passay.PasswordUtils;
import org.passay.Rule;
import org.passay.RuleResult;
import org.passay.RuleResultDetail;

public class WhitespaceRule
implements Rule {
    public static final String CHARS = new String(new byte[]{9, 10, 11, 12, 13, 32}, StandardCharsets.UTF_8);
    public static final String ERROR_CODE = "ILLEGAL_WHITESPACE";

    @Override
    public RuleResult validate(PasswordData passwordData) {
        int charCount = PasswordUtils.getMatchingCharacters(CHARS, passwordData.getPassword()).length();
        if (charCount == 0) {
            return new RuleResult(true);
        }
        return new RuleResult(false, new RuleResultDetail(ERROR_CODE, null));
    }
}

