/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.passay.dictionary.ArrayWordList;
import org.passay.dictionary.Dictionary;
import org.passay.dictionary.WordListDictionary;
import org.passay.dictionary.WordLists;
import org.passay.dictionary.sort.ArraySorter;
import org.passay.dictionary.sort.ArraysSort;

public class DictionaryBuilder {
    private static final ArraySorter SORTER = new ArraysSort();
    private final List<File> files = new ArrayList<File>();
    private boolean caseSensitive;

    public DictionaryBuilder addFile(String path) {
        this.files.add(new File(path));
        return this;
    }

    public DictionaryBuilder setCaseSensitive(boolean flag) {
        this.caseSensitive = flag;
        return this;
    }

    public Dictionary build() {
        try {
            ArrayList<String> wordList = new ArrayList<String>();
            for (File f : this.files) {
                if (!f.exists()) {
                    throw new IllegalArgumentException(f + " does not exist");
                }
                WordLists.readWordList(new FileReader(f), wordList);
            }
            String[] words = new String[wordList.size()];
            wordList.toArray(words);
            return new WordListDictionary(new ArrayWordList(words, this.caseSensitive, SORTER));
        }
        catch (IOException e) {
            throw new RuntimeException("IO error building dictionary", e);
        }
    }
}

