/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.TreeMap;
import org.passay.dictionary.AbstractWordList;
import org.passay.dictionary.WordLists;

public class FileWordList
extends AbstractWordList {
    public static final int DEFAULT_CACHE_SIZE = 5;
    private static final int HUNDRED_PERCENT = 100;
    protected RandomAccessFile file;
    protected int size;
    protected TreeMap<Integer, Long> cache = new TreeMap();

    public FileWordList(RandomAccessFile raf) throws IOException {
        this(raf, true);
    }

    public FileWordList(RandomAccessFile raf, boolean caseSensitive) throws IOException {
        this(raf, caseSensitive, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileWordList(RandomAccessFile raf, boolean caseSensitive, int cachePercent) throws IOException {
        if (cachePercent < 0 || cachePercent > 100) {
            throw new IllegalArgumentException("cachePercent must be between 0 and 100 inclusive");
        }
        this.file = raf;
        this.comparator = caseSensitive ? WordLists.CASE_SENSITIVE_COMPARATOR : WordLists.CASE_INSENSITIVE_COMPARATOR;
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            String a;
            this.file.seek(0L);
            String b = null;
            while ((a = this.file.readLine()) != null) {
                if (a != null && b != null && this.comparator.compare(a, b) < 0) {
                    throw new IllegalArgumentException("File is not sorted correctly for this comparator");
                }
                b = a;
                ++this.size;
            }
            this.intializeCache(cachePercent * this.size / 100);
        }
    }

    private void intializeCache(int cacheSize) throws IOException {
        if (cacheSize > 0) {
            int offset = cacheSize > this.size ? 1 : this.size / cacheSize;
            long pos = 0L;
            this.file.seek(pos);
            for (int i = 0; i < this.size; ++i) {
                this.file.readLine();
                if (i != 0 && i % offset == 0) {
                    this.cache.put(i, pos);
                }
                pos = this.file.getFilePointer();
            }
        }
    }

    @Override
    public String get(int index) {
        this.checkRange(index);
        return this.readFile(index);
    }

    @Override
    public int size() {
        return this.size;
    }

    public RandomAccessFile getFile() {
        return this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        RandomAccessFile randomAccessFile = this.file;
        synchronized (randomAccessFile) {
            this.file.close();
        }
        this.cache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readFile(int index) {
        try {
            RandomAccessFile randomAccessFile = this.file;
            synchronized (randomAccessFile) {
                String s;
                int i = 0;
                if (!this.cache.isEmpty() && this.cache.firstKey() <= index) {
                    i = this.cache.floorKey(index);
                }
                long pos = i > 0 ? this.cache.get(i) : 0L;
                this.file.seek(pos);
                while ((s = this.file.readLine()) != null) {
                    if (i == index) {
                        return s;
                    }
                    ++i;
                }
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading file", e);
        }
        return null;
    }
}

