/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import org.passay.dictionary.TernaryNode;

public class TernaryTree {
    protected static final Comparator<Character> CASE_SENSITIVE_COMPARATOR = new Comparator<Character>(){

        @Override
        public int compare(Character a, Character b) {
            char c2;
            int result = 0;
            char c1 = a.charValue();
            if (c1 < (c2 = b.charValue())) {
                result = -1;
            } else if (c1 > c2) {
                result = 1;
            }
            return result;
        }
    };
    protected static final Comparator<Character> CASE_INSENSITIVE_COMPARATOR = new Comparator<Character>(){

        @Override
        public int compare(Character a, Character b) {
            char c2;
            int result = 0;
            char c1 = Character.toLowerCase(a.charValue());
            if (c1 < (c2 = Character.toLowerCase(b.charValue()))) {
                result = -1;
            } else if (c1 > c2) {
                result = 1;
            }
            return result;
        }
    };
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected final Comparator<Character> comparator;
    private TernaryNode root;

    public TernaryTree() {
        this(true);
    }

    public TernaryTree(boolean caseSensitive) {
        this.comparator = caseSensitive ? CASE_SENSITIVE_COMPARATOR : CASE_INSENSITIVE_COMPARATOR;
    }

    public void insert(String word) {
        if (word != null) {
            this.root = this.insertNode(this.root, word, 0);
        }
    }

    public void insert(String[] words) {
        if (words != null) {
            for (String s : words) {
                this.insert(s);
            }
        }
    }

    public boolean search(String word) {
        return this.searchNode(this.root, word, 0);
    }

    public String[] partialSearch(String word) {
        if (this.comparator == CASE_INSENSITIVE_COMPARATOR) {
            throw new UnsupportedOperationException("Partial search is not supported for case insensitive ternary trees");
        }
        List<String> matches = this.partialSearchNode(this.root, new ArrayList<String>(), "", word, 0);
        String[] results = matches == null ? new String[]{} : matches.toArray(new String[matches.size()]);
        return results;
    }

    public String[] nearSearch(String word, int distance) {
        if (this.comparator == CASE_INSENSITIVE_COMPARATOR) {
            throw new UnsupportedOperationException("Near search is not supported for case insensitive ternary trees");
        }
        List<String> matches = this.nearSearchNode(this.root, distance, new ArrayList<String>(), "", word, 0);
        String[] results = matches == null ? new String[]{} : matches.toArray(new String[matches.size()]);
        return results;
    }

    public List<String> getWords() {
        List<String> words = this.traverseNode(this.root, "", new ArrayList<String>());
        return Collections.unmodifiableList(words);
    }

    public void print(Writer out) throws IOException {
        out.write(this.printNode(this.root, "", 0));
    }

    private TernaryNode insertNode(TernaryNode node, String word, int index) {
        if (index < word.length()) {
            char c = word.charAt(index);
            if (node == null) {
                node = new TernaryNode(c);
            }
            char split = node.getSplitChar();
            int cmp = this.comparator.compare(Character.valueOf(c), Character.valueOf(split));
            if (cmp < 0) {
                node.setLokid(this.insertNode(node.getLokid(), word, index));
            } else if (cmp == 0) {
                if (index == word.length() - 1) {
                    node.setEndOfWord(true);
                }
                node.setEqkid(this.insertNode(node.getEqkid(), word, index + 1));
            } else {
                node.setHikid(this.insertNode(node.getHikid(), word, index));
            }
        }
        return node;
    }

    private boolean searchNode(TernaryNode node, String word, int index) {
        boolean success = false;
        if (node != null && index < word.length()) {
            char c = word.charAt(index);
            char split = node.getSplitChar();
            int cmp = this.comparator.compare(Character.valueOf(c), Character.valueOf(split));
            if (cmp < 0) {
                return this.searchNode(node.getLokid(), word, index);
            }
            if (cmp > 0) {
                return this.searchNode(node.getHikid(), word, index);
            }
            if (index == word.length() - 1) {
                if (node.isEndOfWord()) {
                    success = true;
                }
            } else {
                return this.searchNode(node.getEqkid(), word, index + 1);
            }
        }
        return success;
    }

    private List<String> partialSearchNode(TernaryNode node, List<String> matches, String match, String word, int index) {
        if (node != null && index < word.length()) {
            char c = word.charAt(index);
            char split = node.getSplitChar();
            int cmp = this.comparator.compare(Character.valueOf(c), Character.valueOf(split));
            if (c == '.' || cmp < 0) {
                matches = this.partialSearchNode(node.getLokid(), matches, match, word, index);
            }
            if (c == '.' || cmp == 0) {
                if (index == word.length() - 1) {
                    if (node.isEndOfWord()) {
                        matches.add(match + split);
                    }
                } else {
                    matches = this.partialSearchNode(node.getEqkid(), matches, match + split, word, index + 1);
                }
            }
            if (c == '.' || cmp > 0) {
                matches = this.partialSearchNode(node.getHikid(), matches, match, word, index);
            }
        }
        return matches;
    }

    private List<String> nearSearchNode(TernaryNode node, int distance, List<String> matches, String match, String word, int index) {
        if (node != null && distance >= 0) {
            char c = index < word.length() ? (char)word.charAt(index) : (char)'\uffff';
            char split = node.getSplitChar();
            int cmp = this.comparator.compare(Character.valueOf(c), Character.valueOf(split));
            if (distance > 0 || cmp < 0) {
                matches = this.nearSearchNode(node.getLokid(), distance, matches, match, word, index);
            }
            String newMatch = match + split;
            if (cmp == 0) {
                if (node.isEndOfWord() && distance >= 0 && newMatch.length() + distance >= word.length()) {
                    matches.add(newMatch);
                }
                matches = this.nearSearchNode(node.getEqkid(), distance, matches, newMatch, word, index + 1);
            } else {
                if (node.isEndOfWord() && distance - 1 >= 0 && newMatch.length() + distance - 1 >= word.length()) {
                    matches.add(newMatch);
                }
                matches = this.nearSearchNode(node.getEqkid(), distance - 1, matches, newMatch, word, index + 1);
            }
            if (distance > 0 || cmp > 0) {
                matches = this.nearSearchNode(node.getHikid(), distance, matches, match, word, index);
            }
        }
        return matches;
    }

    private List<String> traverseNode(TernaryNode node, String s, List<String> words) {
        if (node != null) {
            words = this.traverseNode(node.getLokid(), s, words);
            String c = String.valueOf(node.getSplitChar());
            if (node.getEqkid() != null) {
                words = this.traverseNode(node.getEqkid(), s + c, words);
            }
            if (node.isEndOfWord()) {
                words.add(s + c);
            }
            words = this.traverseNode(node.getHikid(), s, words);
        }
        return words;
    }

    private String printNode(TernaryNode node, String s, int depth) {
        StringBuilder buffer = new StringBuilder();
        if (node != null) {
            buffer.append(this.printNode(node.getLokid(), " <-", depth + 1));
            String c = String.valueOf(node.getSplitChar());
            StringBuilder eq = new StringBuilder();
            if (node.getEqkid() != null) {
                eq.append(this.printNode(node.getEqkid(), s + c + "--", depth + 1));
            } else {
                int count = new StringTokenizer(s, "--").countTokens();
                if (count > 0) {
                    --count;
                }
                for (int i = 1; i < depth - count - 1; ++i) {
                    eq.append("   ");
                }
                eq.append(s).append(c).append(LINE_SEPARATOR);
            }
            buffer.append((CharSequence)eq);
            buffer.append(this.printNode(node.getHikid(), " >-", depth + 1));
        }
        return buffer.toString();
    }
}

