/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.passay.dictionary.ArrayWordList;
import org.passay.dictionary.Dictionary;
import org.passay.dictionary.TernaryTree;
import org.passay.dictionary.WordList;
import org.passay.dictionary.WordLists;
import org.passay.dictionary.sort.ArraysSort;

public class TernaryTreeDictionary
implements Dictionary {
    protected final TernaryTree tree;

    public TernaryTreeDictionary(WordList wordList) {
        this(wordList, true);
    }

    public TernaryTreeDictionary(WordList wordList, boolean useMedian) {
        this.tree = wordList.getComparator().compare("A", "a") == 0 ? new TernaryTree(false) : new TernaryTree(true);
        Iterator<String> iterator = useMedian ? wordList.medianIterator() : wordList.iterator();
        while (iterator.hasNext()) {
            this.tree.insert(iterator.next());
        }
    }

    public TernaryTreeDictionary(TernaryTree tt) {
        this.tree = tt;
    }

    @Override
    public boolean search(String word) {
        return this.tree.search(word);
    }

    public String[] partialSearch(String word) {
        return this.tree.partialSearch(word);
    }

    public String[] nearSearch(String word, int distance) {
        return this.tree.nearSearch(word, distance);
    }

    public TernaryTree getTernaryTree() {
        return this.tree;
    }

    public static void main(String[] args) throws Exception {
        block17: {
            ArrayList<FileReader> files = new ArrayList<FileReader>();
            try {
                if (args.length == 0) {
                    throw new ArrayIndexOutOfBoundsException();
                }
                boolean useMedian = false;
                boolean caseSensitive = true;
                boolean search = false;
                boolean partialSearch = false;
                boolean nearSearch = false;
                boolean print = false;
                String word = null;
                int distance = 0;
                for (int i = 0; i < args.length; ++i) {
                    if ("-m".equals(args[i])) {
                        useMedian = true;
                        continue;
                    }
                    if ("-ci".equals(args[i])) {
                        caseSensitive = false;
                        continue;
                    }
                    if ("-s".equals(args[i])) {
                        search = true;
                        word = args[++i];
                        continue;
                    }
                    if ("-ps".equals(args[i])) {
                        partialSearch = true;
                        word = args[++i];
                        continue;
                    }
                    if ("-ns".equals(args[i])) {
                        nearSearch = true;
                        word = args[++i];
                        distance = Integer.parseInt(args[++i]);
                        continue;
                    }
                    if ("-p".equals(args[i])) {
                        print = true;
                        continue;
                    }
                    if ("-h".equals(args[i])) {
                        throw new ArrayIndexOutOfBoundsException();
                    }
                    files.add(new FileReader(args[i]));
                }
                ArrayWordList awl = WordLists.createFromReader(files.toArray(new FileReader[files.size()]), caseSensitive, new ArraysSort());
                TernaryTreeDictionary dict = new TernaryTreeDictionary(awl, useMedian);
                if (search) {
                    if (dict.search(word)) {
                        System.out.println(String.format("%s was found in this dictionary", word));
                    } else {
                        System.out.println(String.format("%s was not found in this dictionary", word));
                    }
                    break block17;
                }
                if (partialSearch) {
                    String[] matches = dict.partialSearch(word);
                    System.out.println(String.format("Found %s matches for %s in this dictionary : %s", matches.length, word, Arrays.asList(matches)));
                    break block17;
                }
                if (nearSearch) {
                    String[] matches = dict.nearSearch(word, distance);
                    System.out.println(String.format("Found %s matches for %s in this dictionary at a distance of %s : %s", matches.length, word, distance, Arrays.asList(matches)));
                    break block17;
                }
                if (print) {
                    dict.getTernaryTree().print(new PrintWriter(System.out, true));
                    break block17;
                }
                throw new ArrayIndexOutOfBoundsException();
            }
            catch (ArrayIndexOutOfBoundsException e) {
                System.out.println("Usage: java " + TernaryTreeDictionary.class.getName() + " \\");
                System.out.println("       <dictionary1> <dictionary2> ... <options> <operation> \\");
                System.out.println("");
                System.out.println("where <options> includes:");
                System.out.println("       -m (Insert dictionary using it's median) \\");
                System.out.println("       -ci (Make search case-insensitive) \\");
                System.out.println("");
                System.out.println("where <operation> includes:");
                System.out.println("       -s <word> (Search for a word) \\");
                System.out.println("       -ps <word> (Partial search for a word) \\");
                System.out.println("           (where word like '.a.a.a') \\");
                System.out.println("       -ns <word> <distance> (Near search for a word) \\");
                System.out.println("       -p (Print the entire dictionary in tree form) \\");
                System.out.println("       -h (Print this message) \\");
                System.exit(1);
            }
        }
    }
}

