/*
 * Decompiled with CFR 0.152.
 */
package org.passay.dictionary;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.passay.dictionary.ArrayWordList;
import org.passay.dictionary.WordList;
import org.passay.dictionary.sort.ArraySorter;

public final class WordLists {
    public static final Comparator<String> CASE_SENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.compareTo(b);
        }
    };
    public static final Comparator<String> CASE_INSENSITIVE_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String a, String b) {
            return a.compareToIgnoreCase(b);
        }
    };
    public static final int NOT_FOUND = -1;

    private WordLists() {
    }

    public static int binarySearch(WordList wordList, String word) {
        Comparator<String> comparator = wordList.getComparator();
        int low = 0;
        int high = wordList.size() - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            int cmp = comparator.compare(wordList.get(mid), word);
            if (cmp < 0) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -1;
    }

    public static ArrayWordList createFromReader(Reader[] readers) throws IOException {
        return WordLists.createFromReader(readers, true);
    }

    public static ArrayWordList createFromReader(Reader[] readers, boolean caseSensitive) throws IOException {
        return WordLists.createFromReader(readers, caseSensitive, null);
    }

    public static ArrayWordList createFromReader(Reader[] readers, boolean caseSensitive, ArraySorter sorter) throws IOException {
        ArrayList<String> words = new ArrayList<String>();
        for (Reader r : readers) {
            WordLists.readWordList(r, words);
        }
        return new ArrayWordList(words.toArray(new String[words.size()]), caseSensitive, sorter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void readWordList(Reader reader, List<String> wordList) throws IOException {
        try {
            String word;
            BufferedReader bufferedReader = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
            while ((word = bufferedReader.readLine()) != null) {
                if (word.isEmpty()) continue;
                wordList.add(word);
            }
        }
        finally {
            reader.close();
        }
    }
}

